# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.Replication.scripts.common_utils.config_params import Params
from plugins.DistributedStorage.implement.tc_config_storage_network import ConfigStorageNetwork


class ConfigStorageNetworkIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_params_gain = ParamsGain(self.project_id, self.pod_id, self.db)
        self.service_name = "FusionStorageBlockReplication"
        parameters = Params(self.project_id, self.pod_id, self.service_name)
        self.fs_args = parameters.get_rep_fsa_params()
        self.fs_args["frontend_storage_network_list"] = self.fs_params_gain.get_frontend_storage_network_info()
        self.fs_args["backend_storage_network_list"] = self.fs_params_gain.get_backend_storage_network_info(
            self.fs_args["frontend_storage_network_list"])

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        return ConfigStorageNetwork(project_id, pod_id, self.fs_args).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return ConfigStorageNetwork(project_id, pod_id, self.fs_args).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
