# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.common.message import Message
from utils.common.fic_base import StepBaseInterface
from utils.common.exception import FCDException
from plugins.DistributedStorageReplication.scripts.implement.fs_14_create_quorum_server import CreateQuorumServerOne


class CreateQuorumServer(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：复制双活创建仲裁服务器，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            CreateQuorumServerOne(project_id, pod_id).procedure()
        except FCDException as e:
            logger.error("[FSBR]createQuorumServer fail msg :{}, details:{}".format(e, traceback.format_exc()))
            return Message(500, str(e))
        except Exception as e:
            logger.error("[FSBR]createQuorumServer fail msg :{}, details:{}".format(e, traceback.format_exc()))
            return Message(500, str(e))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
