# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from utils.common.exception import FCDException
from plugins.DistributedStorageExpansion.scripts.BusinessNewSeparate.implement.tc_install_role import InstallRole
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain


class InstallRoleIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = dict()
        self.fs_args['uvp_install_path'] = ParamsGain(project_id, pod_id, self.db).get_pkg_path('uvp')
        self.install_role = InstallRole(self.project_id, self.pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        try:
            self.install_role.procedure()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626090, str(e)))
        try:
            self.install_role.modify_agent_control_file()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626090, str(e)))
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.install_role.cleanup()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626090, str(e)))
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            self.install_role.cleanup()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626090, str(e)))
        try:
            self.install_role.procedure()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626090, str(e)))
        return Message()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
