# -*- coding:utf-8 -*-
from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from utils.common.exception import FCUException
from plugins.DistributedStorage.common.parameter_gain import ParamsGain
from plugins.DistributedStorage.basic.scripts.impl.tc_update_cmdb import UpdateCMDB


class PreStoreDataToCMDB(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None, suit_id=None):
        super(PreStoreDataToCMDB, self).__init__(project_id, pod_id,
                                                 regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        logger.info('update CMDB.')
        try:
            UpdateCMDB(project_id, pod_id, regionid_list, self.fs_args).procedure()
        except FCUException as e:
            logger.error('update CMDB failed.')
            return Message(500, e)
        except Exception as e:
            logger.error('update CMDB failed.')
            return Message(500, FCUException(620017, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
