# -*- coding: utf-8 -*-
"""
Storage 升级前检查
"""
import traceback
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from platforms.upgradecheck.check_result import CheckResult
from plugins.DistributedStorage.basic.scripts.impl.tc_pre_upgrade_check import \
    PreUpgradeCheck
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class PreCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PreCheck, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start pre upgrade check.')
        check_results = []
        try:
            self.main(check_results, pod_id, project_id)
        except FCUException as e:
            logger.error(traceback.format_exc())
            check_item = CheckResult(
                itemname_ch="分布式存储升级前检查失败",
                itemname_en="DistributedStorage Pre-upgrade Check failed",
                status="failure",
                error_msg_cn=e)
            check_results.append(check_item)
        except Exception as e:
            logger.error(traceback.format_exc())
            check_item = CheckResult(
                itemname_ch="分布式存储升级前检查失败",
                itemname_en="DistributedStorage Pre-upgrade Check failed",
                status="failure",
                error_msg_cn=FCUException(621013, str(e)))
            check_results.append(check_item)
        return Message(200, check_results=check_results)

    def main(self, check_results, pod_id, project_id):
        PreUpgradeCheck(project_id, pod_id, self.fs_args).procedure()
        check_item = CheckResult(
            itemname_ch="分布式存储升级前检查成功",
            itemname_en="DistributedStorage Pre-upgrade Check success",
            status="success")
        check_results.append(check_item)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
