#!/bin/bash
. localrcs
CHECKTYPE=disk_slot_separate
TIMESTAMP=1234
DISKSLOTS=2-6
DISKSLOT=6

check_scsi_controller || {
    CHECKRESULT=failed
    CHECKOUTPUT="113061,,$CONTROLLERS"
    feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
    exit 1
}

myCurl http://$FCDIP/tools/MegaCli.zip -o MegaCli.zip
unzip -o MegaCli.zip || {
    CHECKRESULT=failed
    CHECKOUTPUT="113082"
    feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
    exit 1
}
ENCLOSUREID=$(./MegaCli64 -ENCInfo -aALL | awk '/Device ID/{print $NF;exit}')

DISK_SIZES=
for DISKSLOT in $(seq $(echo $DISKSLOTS | sed 's/-/ /g'));do
    SLOT="${ENCLOSUREID}:${DISKSLOT}"
    CMDOUTPUT=$(./MegaCli64 -pdInfo -PhysDrv["$SLOT"] -aALL)
    if echo "$CMDOUTPUT" | grep 'not found';then
            CHECKRESULT=failed
            CHECKOUTPUT="113081,,$DISKSLOT"
            feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
            exit 1
    else
            DISK_MODEL=$(echo "$CMDOUTPUT" | awk -F : '/Inquiry Data: /{print $2}')
            MEDIA_ERROR=$(echo "$CMDOUTPUT" | awk '/Media Error Count:/{print $NF}')
            OTHER_ERROR=$(echo "$CMDOUTPUT" | awk '/Other Error Count:/{print $NF}')
            PREDICTIVE_ERROR=$(echo "$CMDOUTPUT" | awk '/Predictive Failure Count:/{print $NF}')
            DISK_SIZE=$(echo "$CMDOUTPUT" | awk '/Raw Size:/{print $3}')
            DISK_SIZES="$DISK_SIZES $DISK_SIZE"
            DISK_STATE=$(echo "$CMDOUTPUT" | awk '/Firmware state/{gsub(",","");print $3}')
            if [ x$MEDIA_ERROR != x"0" ] || [ x$PREDICTIVE_ERROR != x"0" ];then
                CHECKRESULT=failed
                CHECKOUTPUT="113083,,$DISKSLOT"
                feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
                exit 1
            elif [ x${DISK_STATE} == x"Online" ];then
                CHECKRESULT=failed
                CHECKOUTPUT="113088,,$DISKSLOT"
                feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
                exit 1
	    elif [ x${DISK_STATE} != x"JBOD" ];then
                CHECKRESULT=failed
                CHECKOUTPUT="113089,,$DISKSLOT,,${DISK_STATE}"
                feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
                exit 1
            else
                CHECKRESULT=pass
                CHECKOUTPUT=$DISK_SIZES
            fi
    fi
done
feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"