# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.utils.interface.DistributedStorage import DistributedStorageTool
from plugins.DistributedStorage.Deploy.scripts.PreCheck.common.device_operate import PreCheckPublicOperate


class AddNodeVersionCheckInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(AddNodeVersionCheckInterface, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.database = BaseOps()
        self.storage_tool = DistributedStorageTool(self.project_id, self.pod_id, self.database)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.procedure()
        except Exception as err:
            logger.error(traceback.format_exc())
            return Message(500, err)
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def procedure(self):
        """
        新增存储节点、新增存储池、扩AZ复用新增存储池：检查存储版本与插件版本是否一致

        """
        logger.info('Querying Login Information')
        fsm_args_lst = self.storage_tool.get_storage_float_ip()
        if not fsm_args_lst:
            err_msg = 'Failed to query the DeviceManager login information from LLD'
            logger.error(err_msg)
            raise Exception(err_msg)
        fsm_args = fsm_args_lst[0]

        logger.info("Querying Product Version")
        product_version = PreCheckPublicOperate.get_product_version(
            fsm_args.get("float_ip"), fsm_args.get("portal_pwd"))

        logger.info("Querying Plugins Version")
        plugins_version = PreCheckPublicOperate.get_plugins_version()
        if product_version != plugins_version:
            err_msg = "plugins_version:{}, Product Site Product Version:{}".format(
                plugins_version, product_version)
            logger.error(err_msg)
            raise HCCIException(626396, err_msg, product_version)

        logger.info("Pass")
