# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.common.ssh_util import Ssh


class Check(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(Check, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        try:
            self.procedure()
        except HCCIException as e1:
            return Message(500, e1)
        except Exception as e2:
            return Message(500, HCCIException(627209, str(e2)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def procedure(self):
        """check fcd 能否ssh 登录到存储节点"""
        bmc_info = self.db.get_install_os_list_info(self.pod_id)
        fb_node_list = [[node.get('manageIp')] + node.get("creuser").split(',')[2:4] for node in bmc_info]
        for fb_node in fb_node_list:
            if len(fb_node) != 3:
                raise HCCIException(113176)
            ip, username, passwd = fb_node
            try:
                Ssh.ssh_create_client(ip, username, passwd)
            except Exception as e:
                raise HCCIException(113177) from e
