# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 分布式存储目录配置更新
"""
import traceback
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.Upgrade.scripts.impl.tc_update_directory_cfg import UpdateDirectoryCfg


class UpdateDirectoryCfgIntf(StepBaseInterface):
    """
    update class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(UpdateDirectoryCfgIntf, self).__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform a update distributed storage directory configuration task
        """
        logger.info('Start update distributed storage directory configuration.')
        logger.info('Try to update distributed storage directory configuration.')
        try:
            UpdateDirectoryCfg(project_id, pod_id).procedure()
        except HCCIException as e:
            logger.error('update distributed storage directory configuration %s.' % (str(e)))
            return Message(500, e)
        except Exception as e:
            exc = traceback.format_exc()
            logger.error('update distributed storage directory configuration %s.' % (str(exc)))
            return Message(500, HCCIException(621014, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
