# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.common.fic_base import StepBaseInterface
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from plugins.DistributedStorage.scripts.implement.tc_create_vm import CreateVM
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain


class CreateVMIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.pod_id = pod_id
        self.project_id = project_id
        self.db = BaseOps()
        params = ParamsGain(self.project_id, self.pod_id, self.db)
        self.fs_args = params.get_manage_converge_args()
        self.fs_args["uvp_install_path"] = params.get_pkg_path('uvp')
        self.vm_create = CreateVM(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署创建VM，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.vm_create.run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.vm_create.delete_created_vm_from_cps()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return CreateVM(project_id, pod_id, self.fs_args).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
