#!/bin/sh

install_version_4_7='4.7-3.2.9.0'
install_version_4_4='4.4-2.0.7'
install_version_4_5='4.5-1.0.1'
install_version_4_2='4.2-1.0.0'
EulerOS_release_2_3='EulerOS release 2.0 (SP3)'
EulerOS_release_2_5='EulerOS release 2.0 (SP5)'
EulerOS_release_2_8='EulerOS release 2.0 (SP8)'

driver_path=$1
system_release=$(cat /etc/euleros-release)

if [[ "$system_release"x == "$EulerOS_release_2_5"x ]]; then
    if [[ $driver_path =~ $install_version_4_7 ]]; then
        install_version=$install_version_4_7
    elif [[ $driver_path =~ $install_version_4_4 ]]; then
        install_version=$install_version_4_4
    elif [[ $driver_path =~ $install_version_4_5 ]] ; then
        install_version=$install_version_4_5
    fi
elif [[ $driver_path =~ $install_version_4_2 && "$system_release"x == "$EulerOS_release_2_3"x ]] ; then
    install_version=$install_version_4_2
else
    echo "error: the driver release can not match system release"
    exit 1
fi

filefmt=`echo "${driver_path##*.}"`

_install()
{
	if [[ $mnlx_path =~ $install_version_4_4 ]]; then
		mnlx_path_base=${mnlx_path%%MLNX*}
		mnlx_path=$mnlx_path_base"MLNX_OFED_LINUX-4.4-2.0.7.0-CentOS7.5-x86_64"
	fi
	
	if [[ $mnlx_path =~ $install_version_4_5 ]] ; then
		mnlx_path_base=${mnlx_path%%NIC*}
		mnlx_path=$mnlx_path_base"MLNX_OFED_LINUX-4.5-1.0.1.0-rhel7.5-x86_64"
	fi
    RPMS_PATH=$mnlx_path"/RPMS"
    rpm_install="kmod-mlnx-ofa_kernel kmod-srp kmod-knem kmod-kernel-mft-mlnx kmod-isert
		   kmod-iser mlnx-ofa_kernel mft mstflint
		   knem libibverbs libmlx ibutils 
           librxe libibcm libibumad libibmad ibsim
           librdmacm opensm dapl perftest mstflint mft srptools 
           cc_mgr dump_pr ibdump infiniband-diags
           infiniband-diags-compat qperf sockperf
           mxm ucx sharp mpi-selector libibprof hcoll
           mlnx-ethtool ofed-scripts" 

	if [[ $mnlx_path =~ $install_version_4_7 ]] ; then
		mnlx_path_base=${mnlx_path%%MLNX*}
		mnlx_path=$mnlx_path_base"MLNX_OFED_LINUX-4.7-3.2.9.0-rhel7.5-x86_64"
        RPMS_PATH=$mnlx_path"/RPMS"
        rpm_install="kmod-mlnx-ofa_kernel kmod-knem kmod-kernel-mft-mlnx
           mlnx-ofa_kernel mstflint
		   knem libibverbs libmlx ibutils 
           librxe libibcm libibumad libibmad ibsim
           librdmacm opensm perftest mstflint srptools 
           cc_mgr dump_pr ibdump infiniband-diags
           infiniband-diags-compat qperf
           sharp mpi-selector mlnx-ethtool ofed-scripts" 
  
        for rpm in $rpm_install;
        do 
            rpm -ivh --nodeps --nosignature --force $RPMS_PATH/MLNX_LIBS/$rpm*.`uname -p`.rpm
        done
        rpm -ivh --nodeps --nosignature --force $RPMS_PATH/COMMON/mft*.rpm
    else
        for rpm in $rpm_install;
        do 
            rpm -ivh --nodeps --nosignature --force $RPMS_PATH/$rpm*.`uname -p`.rpm
        done
    fi
	
    if test -f /etc/init.d/openibd; then
        sed '/load_module mlx5_core/a\        files=`find /sys -name roce_lag_enable`;for file in $files;do echo 0 > $file;done' -i /etc/init.d/openibd
        echo "disable roce_lag_enable"
    else
        echo "/etc/init.d/openib is not exist"
    fi

	echo "---delete ibdump----"
    rm -r /usr/bin/ibdump
	return 0
}

#׼װ
readyenvironment()
{
	if test -f $driver_path; then
		echo "start to ready install environment"
	else
		echo "mlnx drvier file is not exsit in" $driver_path
		exit
	fi

	if [ "tgz" = $filefmt ];then
		mnlx_path=`basename $driver_path .tgz`
		tar xf $driver_path	
	fi
	
	if [ "iso" = $filefmt ];then
		mnlx_path=/tmp/mnlxmnt
		mkdir -p $mnlx_path
		mount $driver_path $mnlx_path
	fi
}

cleanenvironment()
{
	
	if [ "iso" = $filefmt ];then
		umount $mnlx_path
	fi
	rm -rf $mnlx_path
}

#汾ǷҪҪֱ˳˴β
checkversion()
{
	if test -f /usr/sbin/ofed_uninstall.sh; then
		if  ! test -f /usr/bin/ofed_info || ! ofed_info -s | grep "$install_version" ; then
			echo "Current version is $install_version, need to install"
		else
			echo "Current version is $install_version, no need to install" 
			exit
		fi	
	fi
}

#ִֻļ滻֮ȴЧ
upgrade()
{	
	checkversion
	readyenvironment
	echo 'Start Install ...'
	_install
	echo 'Install Finished'
	echo 'Please reboot to make driver effective'
	cleanenvironment
}

#һβִаװ֮Ч
install()
{
	upgrade
}
#ʹOFEDԴжؽűж
uninstall()
{
	if test -f /usr/sbin/ofed_uninstall.sh; then
		ofed_uninstall.sh
	fi
}

case $2 in 
			upgrade)
				upgrade
				;;
			install)
				install
				;;
			uninstall)
				uninstall
				;;
			*)
				echo "Run script like this:"
				echo "./ofed_install.sh MLNX_ISO_PATH upgrade"
				echo "./ofed_install.sh MLNX_ISO_PATH install"
				echo "./ofed_install.sh MLNX_ISO_PATH uninstall"
				;;
esac
exit $?

