# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 升级任务
"""
import os
import traceback

import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.common.parameter_gain import ParamsGain
from plugins.DistributedStorage.basic.scripts.impl.tc_self_upgrade import DeployManagerSelfUpgrade


class SelfUpgrade(StepBaseInterface):
    """
    Packege Upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(SelfUpgrade, self).__init__(project_id, pod_id, regionid_list)
        params_gain = ParamsGain(project_id, pod_id, regionid_list)
        pkg_name, pkg_dir = params_gain.get_storage_package()
        self.fs_args = params_gain.get_args(suit_id)
        self.fs_args["package_name"] = pkg_name
        self.fs_args["package_path"] = os.path.join(pkg_dir, pkg_name)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start deploy manager self upgrade task')
        try:
            DeployManagerSelfUpgrade(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('deploy manager self upgrade failed')
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            logger.error('deploy manager self upgrade task failed')
            return Message(500, FCUException(621003, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('retry deploy manager self upgrade task.')
        try:
            DeployManagerSelfUpgrade(project_id, pod_id, self.fs_args).retry()
        except FCUException as e:
            logger.error(traceback.format_exc())
            logger.error('retry deploy manager self upgrade task failed')
            return Message(500, e)
        except Exception as e:
            logger.error('retry deploy manager self upgrade failed')
            logger.error(traceback.format_exc())
            return Message(500, FCUException(621003, str(e)))
        return Message(200)
