# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 回退入口
"""
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.basic.scripts.impl.tc_rollback_upgrade_pkg import UpgradePkg
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class RollbackPkg(StepBaseInterface):
    """
    Rollback class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(RollbackPkg, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform a fallback task
        """
        logger.info('Start upgrade rollback task.')
        try:
            UpgradePkg(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('rollback pkg failed')
            return Message(500, e)
        except Exception as e:
            logger.error('rollback pkg failed')
            return Message(500, FCUException(620011, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('Retry upgrade rollback task.')
        try:
            UpgradePkg(project_id, pod_id, self.fs_args).retry()
        except FCUException as e:
            logger.error('Retry upgrade rollback task failed')
            return Message(500, e)
        except Exception as e:
            logger.error('Retry upgrade rollback task failed')
            return Message(500, FCUException(620011, str(e)))
        return Message(200)
