# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.business.vm_util import can_vm_pinged_to


class FsmIPConnectivityCheck(object):
    """
    FSM Float IP 连通性检查
    """

    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.param_util = ParamUtil()

    def check_produce_storage_fsm_ip(self):
        logger.info("begin to check produce_sotrage_fsm_ip")
        service_name = "FusionStorageBlockReplication"
        param_name = "produce_storage_fsm_ip"
        produce_storage_fsm_ip = self.param_util.get_param_value(self.pod_id, service_name, param_name)
        if produce_storage_fsm_ip:
            logger.info("node info:{}".format(produce_storage_fsm_ip))
            if not can_vm_pinged_to(produce_storage_fsm_ip):
                raise HCCIException("113008", str(produce_storage_fsm_ip))
        else:
            logger.error("no produce_storage_fsm_ip node")

    def procedure(self):
        try:
            self.check_produce_storage_fsm_ip()
        except HCCIException as e1:
            logger.error(traceback.format_exc())
            raise e1
        except Exception as e2:
            logger.error(traceback.format_exc())
            raise e2
