#!/bin/bash
. localrcs

TIMESTAMP=1234
DIF_TOOL=hioadm
CHECKTYPE=nvmedif
CHECKRESULT=pass
if lspci -n | grep -E '19e5:0123|19e5:3714';then
	myCurl http://$FCDIP/tools/$DIF_TOOL -o $DIF_TOOL
	if [ $? -eq 0 ];then
		true
	else
		CHECKRESULT=failed
		CHECKOUTPUT="113131,,http://$FCDIP/tools/$DIF_TOOL"
		feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
		exit 1
	fi

else
	CHECKRESULT=pass
	CHECKOUTPUT="Can not find valid NVME device, skip."
	feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
	exit 0
fi

chmod +x hioadm
mkdir -p /opt/hio
NVMELIST=""
for nvme in $(./hioadm info | awk '/\|---- /{print $(NF-1)}');do
	echo y|./hioadm format -d $nvme -m 1 -t 0 &>format.log && {
	NVMELIST="$NVMELIST",$nvme
	CHECKRESULT=pass
	CHECKOUTPUT="Successfully formated $NVMELIST"
	} || {
	CHECKRESULT=failed
	CHECKOUTPUT="113132,,$nvme,,$(cat format.log)"
	break
	}
done
feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
