# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import collections

from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.Deploy.scripts.PreCheck.implement.job_expand_node_cache_check import CheckPoolNodeSSD


class CheckPoolNodeSSDIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(CheckPoolNodeSSDIntf, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = dict()
        self.fs_args['fsm_float_ip'] = self.db.get_user_input_cloud_param_by_key(
            self.project_id, "expansion_az_fsm_float_ip")
        self.fs_args['fsm_admin_password'] = self.db.get_user_input_cloud_param_by_key(
            self.project_id, "reuse_fsm_admin_passwd")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def execute(self, project_id, pod_id):
        try:
            self.main()
        except HCCIException as e1:
            return Message(500, e1)
        except Exception as e2:
            return Message(500, e2)
        return Message(200)

    def main(self):
        ex_osd_list = self.db.get_install_os_list_info(self.pod_id)
        pool_name_and_node_map = collections.defaultdict(list)
        for node in ex_osd_list:
            pool_name_and_node_map[node.get("storage_pool_name_and_slot")].append(node)
        for _, node_list in pool_name_and_node_map.items():
            self.fs_args['ex_osd_list'] = node_list
            check_pool_node_ssd = CheckPoolNodeSSD(self.project_id, self.pod_id, self.fs_args)
            check_pool_node_ssd.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)
