# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import time

import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.fic_base import TestCase
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.constant.path_constant import ProjectPluginsPath
from utils.business.hardware_driver_util import DriverApi
from utils.business.project_condition_utils import get_project_condition_boolean
from plugins.ResourceCheck.common.libs import common_libs


class DoClearLocalDisk(TestCase):

    def procedure(self):
        timestamp = str(int(time.time()))
        check_type = 'clear_local_disk'
        arm_script_path = "/DistributedStorage/Deploy/scripts/PreCheck/shells/arm_clear_local_disk.sh"
        x86_script_path = "/DistributedStorage/Deploy/scripts/PreCheck/shells/config_clear_local_disk.sh"
        common_libs.check_flag()
        common_libs.purge_http_log()
        self.logger_info("Begin to get nodes  information.")
        storage_nodes = self.db.get_install_os_list_info(self.pod_id)
        rep_nodes = self.db.get_install_os_list_info(self.pod_id, component='rep')
        storage_nodes += rep_nodes
        bmc_ip_list = []
        plugin_path = ProjectPluginsPath.project_plugins_path()
        if get_project_condition_boolean(self.project_id, 'TenantStorFB80_ARM'):
            script_src_file = "{}{}".format(plugin_path, arm_script_path)
        else:
            script_src_file = "{}{}".format(plugin_path, x86_script_path)
        for node in storage_nodes:
            node_bmc_ip = node["bmc_ip"]
            # 如果是软RAID就不做清理
            if not DriverApi().check_host_is_hard_raid(node_bmc_ip):
                continue
            bmc_ip_list.append(node_bmc_ip)
            common_libs.create_check_script(script_src_file, node["bmc_ip"], TIMESTAMP=timestamp, CHECKTYPE=check_type)
        if len(bmc_ip_list) != 0:
            common_libs.check_all_result(bmc_ip_list, check_type, timestamp)


class ClearLocalDisk(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(ClearLocalDisk, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.implement = DoClearLocalDisk(project_id, pod_id)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        try:
            self.implement.procedure()
        except HCCIException as e1:
            logger.debug(str(e1))
            return Message(500, e1)
        except Exception as e2:
            logger.debug(str(e2))
            return Message(500, HCCIException('113999', str(e2)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

