/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dm;

import com.huawei.dm.BuildHardCode;
import com.huawei.dm.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptModifyPwd {
    private static final String ALGORITHM_GROUP = "AES/CBC/PKCS5Padding";
    private static final String ENCRYPT_ALGORITHM = "AES";
    private static final int IV_BYTE_NUMBER = 16;
    private static final int KEY_BYTE_NUMBER = 16;
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String JAR_FULL_PATH = System.getProperty("java.class.path");
    private static final Pattern PATTERN = Pattern.compile("keystorePass=\"[^ ]+\"");
    private static String jarDir;
    private static String pwdEncrypt;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Util.getInstance().logToFile("param error!");
            return;
        }
        String string = stringArray[0];
        File file = new File(JAR_FULL_PATH);
        jarDir = file.getParent();
        try {
            pwdEncrypt = EncryptModifyPwd.encrypt(string);
        }
        catch (Exception exception) {
            Util.getInstance().logToFile("encrypt password failed.");
        }
        String string2 = jarDir + File.separator + ".." + File.separator + ".." + File.separator + "tomcat_dynamicport_bat";
        EncryptModifyPwd.modifyPortBat(string2);
    }

    private static String encrypt(String string) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_GROUP);
        SecretKeySpec secretKeySpec = new SecretKeySpec(EncryptModifyPwd.getKey(), ENCRYPT_ALGORITHM);
        byte[] byArray = EncryptModifyPwd.generateRandom();
        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray));
        EncryptModifyPwd.writeRandomIV(byArray);
        byte[] byArray2 = cipher.doFinal(string.getBytes(DEFAULT_CHARSET));
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(byArray2);
    }

    private static void modifyPortBat(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < Objects.requireNonNull(fileArray).length; ++i) {
            String string2;
            try {
                string2 = fileArray[i].getCanonicalPath();
            }
            catch (IOException iOException) {
                Util.getInstance().logToFile("get canonical path failed.");
                continue;
            }
            String string3 = EncryptModifyPwd.getPwdBefore(string2);
            EncryptModifyPwd.readWriteFiles(string2, string3, pwdEncrypt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPwdBefore(String string) {
        String string2;
        Object object;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        String string3 = null;
        try {
            object = new File(string);
            inputStreamReader = new FileReader((File)object);
            bufferedReader = new BufferedReader(inputStreamReader);
            string2 = "";
            while ((string2 = bufferedReader.readLine()) != null && !string2.contains("keystorePass")) {
            }
            string3 = string2;
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Util.getInstance().logToFile("get password before failed.");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    Util.getInstance().logToFile("close stream error when get password before.");
                }
            }
        }
        object = PATTERN.matcher(string3);
        string2 = null;
        if (((Matcher)object).find()) {
            string2 = ((Matcher)object).group(0);
        }
        String string4 = string2.split("keystorePass=")[1].trim();
        return string4.substring(1, string4.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readWriteFiles(String string, String string2, String string3) {
        RandomAccessFile randomAccessFile = null;
        try {
            String string4;
            randomAccessFile = new RandomAccessFile(string, "rw");
            long l = 0L;
            while ((string4 = randomAccessFile.readLine()) != null) {
                long l2 = randomAccessFile.getFilePointer();
                if (string4.contains(string2)) {
                    String string5 = string4.replace(string2, string3);
                    randomAccessFile.seek(l);
                    randomAccessFile.writeBytes(string5);
                }
                l = l2;
            }
        }
        catch (Exception exception) {
            Util.getInstance().logToFile("modify file failed.");
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    Util.getInstance().logToFile("close stream error when read file.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRandomIV(byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            String string = jarDir + File.separator + ".." + File.separator + "conf" + File.separator + "iv.cfg";
            File file = new File(string);
            if (file.exists() && !file.delete()) {
                Util.getInstance().logToFile("delete old iv file failed.");
            }
            if (!file.createNewFile()) {
                Util.getInstance().logToFile("create iv file failed.");
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            Util.getInstance().logToFile("IO exception happened when write iv.");
        }
        catch (Exception exception) {
            Util.getInstance().logToFile("unknown exception happened when write iv.");
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Util.getInstance().logToFile("close stream error when write iv.");
                }
            }
        }
    }

    private static byte[] generateRandom() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private static byte[] getKey() throws IOException, URISyntaxException, GeneralSecurityException {
        String string = jarDir + File.separator + ".." + File.separator + "conf" + File.separator + "CrtHardCode";
        Optional<X509Certificate> optional = Util.getInstance().readCertBuf(BuildHardCode.getCertificationBytes(string));
        byte[] byArray = optional.get().getPublicKey().getEncoded();
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        return byArray2;
    }
}

