/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.Serializable;
import java.lang.invoke.MethodHandleInfo;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;

public final class SerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    private final Class<?> capturingClass;
    private final String functionalInterfaceClass;
    private final String functionalInterfaceMethodName;
    private final String functionalInterfaceMethodSignature;
    private final String implClass;
    private final String implMethodName;
    private final String implMethodSignature;
    private final int implMethodKind;
    private final String instantiatedMethodType;
    private final Object[] capturedArgs;

    public SerializedLambda(Class<?> clazz, String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, Object[] objectArray) {
        this.capturingClass = clazz;
        this.functionalInterfaceClass = string;
        this.functionalInterfaceMethodName = string2;
        this.functionalInterfaceMethodSignature = string3;
        this.implMethodKind = n;
        this.implClass = string4;
        this.implMethodName = string5;
        this.implMethodSignature = string6;
        this.instantiatedMethodType = string7;
        this.capturedArgs = (Object[])Objects.requireNonNull(objectArray).clone();
    }

    public String getCapturingClass() {
        return this.capturingClass.getName().replace('.', '/');
    }

    public String getFunctionalInterfaceClass() {
        return this.functionalInterfaceClass;
    }

    public String getFunctionalInterfaceMethodName() {
        return this.functionalInterfaceMethodName;
    }

    public String getFunctionalInterfaceMethodSignature() {
        return this.functionalInterfaceMethodSignature;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    public String getImplMethodSignature() {
        return this.implMethodSignature;
    }

    public int getImplMethodKind() {
        return this.implMethodKind;
    }

    public final String getInstantiatedMethodType() {
        return this.instantiatedMethodType;
    }

    public int getCapturedArgCount() {
        return this.capturedArgs.length;
    }

    public Object getCapturedArg(int n) {
        return this.capturedArgs[n];
    }

    private Object readResolve() throws ReflectiveOperationException {
        try {
            Method method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method method = SerializedLambda.this.capturingClass.getDeclaredMethod("$deserializeLambda$", SerializedLambda.class);
                    method.setAccessible(true);
                    return method;
                }
            });
            return method.invoke(null, this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ReflectiveOperationException) {
                throw (ReflectiveOperationException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Exception in SerializedLambda.readResolve", privilegedActionException);
        }
    }

    public String toString() {
        String string = MethodHandleInfo.referenceKindToString(this.implMethodKind);
        return String.format("SerializedLambda[%s=%s, %s=%s.%s:%s, %s=%s %s.%s:%s, %s=%s, %s=%d]", "capturingClass", this.capturingClass, "functionalInterfaceMethod", this.functionalInterfaceClass, this.functionalInterfaceMethodName, this.functionalInterfaceMethodSignature, "implementation", string, this.implClass, this.implMethodName, this.implMethodSignature, "instantiatedMethodType", this.instantiatedMethodType, "numCaptured", this.capturedArgs.length);
    }
}

