#!/bin/bash
LOG_PATH="/var/log/pangea_internal_upgrade/"
LOG_FILE="/var/log/pangea_internal_upgrade/idm_upgrade.log"
IDM_VER_PATH="/usr/lib/modules/pangea_idmdriver/target"

#获取当前版本号
cur_kernel_ver=$(uname -r |awk -F 'euleros' '{print $2}')
#出rpm包时的内核大版本
rpm_build_kernel="v2r9.aarch64"
build_os_type="Euler"
#出rpm包时的内核版本
rpm_build_kernel_rel="4.19.90-vhulk2006.2.0.h171.eulerosv2r9.aarch64"
cur_kernel_rel=$(uname -r)

function log()
{
	if [ ! -d "$LOG_PATH" ]; then 
		mkdir "$LOG_PATH" 
	fi 

	if [ ! -f "$LOG_FILE" ]; then 
		touch "$LOG_FILE" 
	fi 

	chmod 640 "$LOG_FILE" 
	echo "$(date +"[%Y-%m-%d %H:%M:%S,%N]") [$0:${BASH_LINENO}] [$1]: [IDM] $2" >> ${LOG_FILE}
}

function check_product_env()
{
    support_product_type=("STL6SPCM" "STL6SPCN" "STL6SPCO" "STL6IEC2F001" "STL6IEX2F001" "STL6SPCY" "STL6SPCX"
        "STL6SPCY55" "STL6SPCY44" "STL6SPCH01" "STL6SPCH02" "STL6SPCY91" "STL6SPCY92")
    support_product_num=${#support_product_type[@]}
    cur_product_type=$(dmidecode -t 2 |grep "Product Name" -i | awk -F ': ' '{print $2}')

    for((i=0;i<$support_product_num;i++)) do
        if [ "$cur_product_type" == "${support_product_type[i]}" ]; then
            break
        fi
    done;

    #循环完支持列表还没找到说明不支持
    if [ "$i" -ge  "$support_product_num" ]; then
        log "INFO" "Current environment is Product Name: ${cur_product_type}, not need base driver."
        #打印到屏显,便于现网定位
        echo "NOT_MATCH"
        exit 2
    fi
}

# 步骤1.smartkit升级使用,多版本共包,升级前由驱动判定是不是大西洋/太平洋/新北冰洋/DPU的环境
check_product_env

# 步骤2.smartkit升级使用,多版本共包,升级前由驱动判定系统(Eluer/Uvp)是否匹配
current_os_type="Euler"
# 先判断uvp文件是否存在,存在才能获取内容,否则屏显会打印文件不存在,smartkit工具识别不了
if [ -f "/etc/uvp_version" ];then
	if [ $(cat /etc/uvp_version |wc -l) -ne 0 ];then
		current_os_type="Uvp"
	fi
fi
if [ "$build_os_type" != "$current_os_type" ]; then
    log "INFO" "Current os type is $current_os_type, rpm build os type is $build_os_type, not match."
	#打印到屏显,便于现网定位
    echo "NOT_MATCH"	
    exit 2
fi

function handle_not_match()
{
    local cur_kernel_ver=$1
    local rpm_build_kernel_ver=$2

    log "INFO" "Current kernel version is $cur_kernel_ver, rpm build kernel ver is $rpm_build_kernel_ver, not match."
    #打印到屏显,便于现网定位
    echo "NOT_MATCH"
    exit 2
}

# 步骤2.smartkit升级使用,升级前由驱动判定内核版本是否匹配
# 欧拉v2r9版本不共包，需要大小版本严格匹配
if [[ "$rpm_build_kernel_rel" =~ "eulerosv2r9" ]]; then
    if [[ "$rpm_build_kernel_rel" != "$cur_kernel_rel" ]] || [[ ! "$cur_kernel_rel" ]]; then
        handle_not_match "$cur_kernel_rel" "$rpm_build_kernel_rel"
    fi
else 
    # 有明确结论，欧拉R10及以后的版本保证R版本内核态兼容性，即只匹配大版本即可
    if [ "$rpm_build_kernel" != "$cur_kernel_ver" -o ! "$cur_kernel_ver" ]; then
        handle_not_match "$cur_kernel_ver" "$rpm_build_kernel"
    fi
fi

# 步骤3.smartkit升级使用,多版本共包,升级前由驱动判定驱动是否安装
if [ ! -e "$IDM_VER_PATH/version.txt" ];then
	log "INFO" "can't find idm version.txt."
	echo "--"
	exit 3
fi

IDM_VER=$(cat $IDM_VER_PATH/version.txt | grep -i "IDM_RELEASE_VER" | awk '{print $2}')
if [ -z "$IDM_VER" ]; then
	log "ERR" "get idm version fail."
	echo "GET_FAIL"
	exit 1
fi

KERNEL_VERSION_PREFIX=$(cat $IDM_VER_PATH/version.txt | grep -i "KERNEL_VER" | awk '{print $2}' | awk -F- '{print $1}')
if [ -z "$KERNEL_VERSION_PREFIX" ]; then
	log "ERR" "get knl version fail."
	echo "GET_FAIL"
	exit 1
fi

log "INFO" "cur version $KERNEL_VERSION_PREFIX-$IDM_VER"

echo "$KERNEL_VERSION_PREFIX-$IDM_VER"
exit 0

