#! /bin/bash
# Copyright (c) 2022-2022 Huawei Technologies Co., Ltd.
# All rights reserved.
#

PCIE_EP_CRON="/etc/pcie_ep_cron"
SCRIPT_PATCH="/usr/sbin"
PCIE_EP_FILE_NAME="pcie_ep_link_check.sh"
PCIE_EP_POLLING_CMD="* * * * * flock -x -w 60 $SCRIPT_PATCH/$PCIE_EP_FILE_NAME -c 'sh $SCRIPT_PATCH/$PCIE_EP_FILE_NAME >/dev/null 2>&1'"

function check_pcie_ep_link_already_exit()
{
    local pcie_check_already_add=$(crontab -u root -l | grep "${PCIE_EP_FILE_NAME}" -c)
    if [ $pcie_check_already_add -ne 0 ]; then
        echo "pcie ep link crontab already exits."
        return 1
    fi
    return 0
}

function uninstall_crond_task()
{
    crontab -u root -l | grep -v "#" > $PCIE_EP_CRON

    check_pcie_ep_link_already_exit
    if [ $? -eq 1 ];then
        # 删除命令
        sed -i "/$PCIE_EP_FILE_NAME/d" $PCIE_EP_CRON
    fi

    crontab $PCIE_EP_CRON -u root
    systemctl reset-failed crond >/dev/null 2>&1
    service crond restart > /dev/null 2>&1

    if [ -f "$PCIE_EP_CRON" ]; then
        rm -f $PCIE_EP_CRON
    fi
}

function install_crond_task()
{
    crontab -u root -l | grep -v "#" > $PCIE_EP_CRON

    check_pcie_ep_link_already_exit
    if [ $? -ne 1 ]; then
        echo "$PCIE_EP_POLLING_CMD" >> $PCIE_EP_CRON
    fi

    crontab $PCIE_EP_CRON -u root
    systemctl reset-failed crond > /dev/null 2>&1
    service crond restart > /dev/null 2>&1

    if [ -f "$PCIE_EP_CRON" ]; then
        rm -f $PCIE_EP_CRON
    fi
}

cp $PCIE_EP_FILE_NAME $SCRIPT_PATCH
chmod 777 $SCRIPT_PATCH/$PCIE_EP_FILE_NAME

uninstall_crond_task

install_crond_task

echo "INFO: pcie ep link check deploy success."
