#!/bin/bash
LOG_PATH="/var/log/pangea_internal_upgrade/"
LOG_FILE="/var/log/pangea_internal_upgrade/base_upgrade.log"
PCIEINF_VER_PATH="/usr/lib/modules/pangea_pcieinf_driver/target"
BSP_VER_PATH="/usr/lib/modules/pangea_bspdriver/target"
CMA_VER_PATH="/usr/lib/modules/pangea_cmadriver/target"
BASE_KNL_VER_PATH="/usr/local/pangea_base"
root_dir="$(dirname $(readlink -f $(dirname $0)))"

#出rpm包时的内核版本eulerosv2r10.aarch64或h171.eulerosv2r9.aarch64
rpm_build_kernel="h462.eulerosv2r9.aarch64"
#出包是的内核类型Euler/Uvp
build_os_type="Euler"

#获取当前环境的内核版本号，v2r9的h版本之间不兼容，需要细分
if [[ $(uname -r) == *".eulerosv2r9."* ]]; then
    cur_kernel_ver=$(uname -r | awk -F '.' '{print $(NF-2)"."$(NF-1)"."$NF}')
else
    cur_kernel_ver=$(uname -r | awk -F '.' '{print $(NF-1)"."$NF}')
fi

function log()
{
	if [ ! -d "$LOG_PATH" ]; then
		mkdir "$LOG_PATH"
	fi

	if [ ! -f "$LOG_FILE" ]; then
		touch "$LOG_FILE"
	fi

	chmod 640 "$LOG_FILE"
	echo "$(date +"[%Y-%m-%d %H:%M:%S,%N]") [$0:${BASH_LINENO}] [$1]: [PCIEINF] $2" >> ${LOG_FILE}
}
# 步骤1.smartkit升级使用,多版本共包,升级前由驱动判定是不是大西洋/太平洋/新北冰洋/DPU/介质框的环境
check_Pacific_envir=$(dmidecode -t2 | grep "STL6SPCM")
check_Atlantic_envir=$(dmidecode -t2 | grep "STL6SPCN")
check_Arctic_envir=$(dmidecode -t2 | grep "STL6SPCO")
check_Dpu_envir=$(dmidecode -t2 | grep -E "STL6SPCIA|STL6IEX2F001|STL6IEC2F001")
check_Donghai_envir=$(dmidecode -t2 | grep -E "STL6SPCY|STL6SPCX|STL6SPCY44|STL6SPCY55|STL6SPCH01|STL6SPCH02")
check_MediaBox_envir=$(dmidecode -t2 | grep -E "STL6SPCY91|STL6SPCY92")
now_envir=$(dmidecode -t2 | grep "Product Name")
if [ -z "${check_Pacific_envir}" ] && [ -z "${check_Atlantic_envir}" ] && [ -z "${check_Arctic_envir}" ] && \
    [ -z "${check_Dpu_envir}" ] && [ -z "${check_Donghai_envir}" ] && [ -z "${check_MediaBox_envir}" ]; then
    log "INFO" "Current environment is taishan, install memfknl."
    if [ ! -e $BASE_KNL_VER_PATH/base_knl_version.xml ]
    then
        # taishan 没有灌装memf时，一定获取不到版本号
        BASE_KNL_VER="0000"
    else
        # taishan服务器
        BASE_KNL_VER=$(cat $BASE_KNL_VER_PATH/base_knl_version.xml | grep -w Version | sed 's/^.*<Version>//g' | sed 's/<\/Version>.*$//g')
        if [ -z $BASE_KNL_VER ]; then
            log "ERR" "get base knl version fail."
            echo "GET_FAIL"
            exit 1
        fi
    fi
    echo "$BASE_KNL_VER"
    exit 0
fi

# 步骤2.smartkit升级使用,多版本共包,升级前由驱动判定系统(Eluer/Uvp)是否匹配
current_os_type="Euler"
# 先判断uvp文件是否存在,存在才能获取内容,否则屏显会打印文件不存在,smartkit工具识别不了
if [ -f "/etc/uvp_version" ];then
	if [ $(cat /etc/uvp_version |wc -l) -ne 0 ];then
		current_os_type="Uvp"
	fi
fi
if [ "$build_os_type" != "$current_os_type" ]; then
    log "INFO" "Current os type is $current_os_type, rpm build os type is $build_os_type, not match."
	#打印到屏显,便于现网定位
    echo "NOT_MATCH"
    exit 2
fi

# 步骤3.smartkit升级使用,多版本共包,升级前由驱动判定内核版本是否匹配
if [ "$rpm_build_kernel" != "$cur_kernel_ver" -o ! "$cur_kernel_ver" ]; then
    log "INFO" "Current kernel version is $cur_kernel_ver, rpm build kernel ver is $rpm_build_kernel, not match."
	#打印到屏显,便于现网定位
    echo "NOT_MATCH"
    exit 2
fi

# 步骤4.smartkit升级使用,多版本共包,升级前由驱动判定驱动是否安装
# 文件不存在：1.老包场景 2.新包场景，文件缺失    两种情况都通过老的升级方式去获取版本号
if [ ! -e "$BASE_KNL_VER_PATH/base_knl_version.xml" ];then
    log "INFO" "can't find base knl version.xml, this is old package."
    if [ ! -e "$PCIEINF_VER_PATH/version.txt" ];then
        log "INFO" "can't find pcieinf version.xml."
        echo "--"
        exit 3
    fi
    PCIEINF_VER=$(cat $PCIEINF_VER_PATH/version.txt | grep -i "PCIE_RELEASE_VER" | awk '{print $2}')
    if [ -z $PCIEINF_VER ]; then
        log "ERR" "get pcieinf version fail."
        echo "GET_FAIL"
        exit 1
    fi

    if [ ! -e "$BSP_VER_PATH/version.txt" ];then
        log "INFO" "can't find bsp version.xml."
        echo "--"
        exit 3
    fi
    BSP_VER=$(cat $BSP_VER_PATH/version.txt | grep -i "BSP_RELEASE_VER" | awk '{print $2}')
    if [ -z $BSP_VER ]; then
        log "ERR" "get bsp version fail."
        echo "GET_FAIL"
        exit 1
    fi

    # 北冰洋的环境还需要获取cma的版本号
    if [ -n "$check_Arctic_envir" ]; then
        if [ ! -e "$CMA_VER_PATH/version.txt" ];then
            log "INFO" "can't find cma version.xml."
            echo "--"
            exit 3
        fi
        CMA_VER=$(cat $CMA_VER_PATH/version.txt | grep -i "CMA_RELEASE_VER" | awk '{print $2}')
        if [ -z $CMA_VER ]; then
            log "ERR" "get cma version fail."
            echo "GET_FAIL"
            exit 1
        fi
        log "INFO" "cur version $PCIEINF_VER-$BSP_VER-$CMA_VER"
        echo "$PCIEINF_VER-$BSP_VER-$CMA_VER"
    else
        log "INFO" "cur version $PCIEINF_VER-$BSP_VER"
        echo "$PCIEINF_VER-$BSP_VER"
    fi
    exit 0
fi

# 新包场景
BASE_KNL_VER=$(cat $BASE_KNL_VER_PATH/base_knl_version.xml | grep -w Version | sed 's/^.*<Version>//g' | sed 's/<\/Version>.*$//g')
if [ -z $BASE_KNL_VER ]; then
    log "ERR" "get base knl version fail."
    echo "GET_FAIL"
    exit 1
fi
log "INFO" "cur version $BASE_KNL_VER"
echo "$BASE_KNL_VER"
exit 0

