#! /bin/bash
# Copyright (c) 2011-2015 Huawei Technologies Co., Ltd.
# All rights reserved.
#
LOG_FILE="/var/log/pangea_internal_upgrade/base_upgrade.log"
LOG_DIR="/var/log/pangea_internal_upgrade"

## ں˰汾check,ֶװ
KERNEL=$(cat version.txt | grep KERNEL_VER |awk -F '.' '{print $(NF-1)"."$NF}')
cur_kernel_ver=$(uname -r |awk -F '.' '{print $(NF-1)"."$NF}')
# ֤·
if [ ! -d ${LOG_DIR} ];
then
    mkdir -vp ${LOG_DIR}
fi

if [ "$KERNEL" != "$cur_kernel_ver" -o ! "$cur_kernel_ver" ]
then
    echo "Current kernel version is $cur_kernel_ver, pcieinf rpm kernel ver is $KERNEL, not match." >> ${LOG_FILE}
    echo "IF YOU INSTALL IT, THE OS WILL CRASH !!!!!!!!" >> ${LOG_FILE}
    #ӡ,λ
    echo "Current kernel version is $cur_kernel_ver, pcieinf rpm kernel ver is $KERNEL, not match."
    exit 1
fi
chmod 640 *.txt
# install autorun script
echo "Start boot service: pangeapcieinfservice" >> ${LOG_FILE}
dos2unix pangeapcieinfservice 2> /dev/null
cp pangeapcieinfservice /usr/sbin/ -rf

dos2unix pcieinf.service 2> /dev/null
cp pcieinf.service /usr/lib/systemd/system/ -rf

groupadd -g 8004 GroupPcieInf >> ${LOG_FILE} 2>&1
useradd -g GroupPcieInf -d /home/pcieinf -s /sbin/nologin -u 8004 pcieinf >> ${LOG_FILE} 2>&1
chown -h pcieinf:GroupPcieInf /usr/lib/modules/pangea_pcieinf_driver/target/pitest_diag_server >> ${LOG_FILE} 2>&1
chown -h root:GroupPcieInf /usr/lib/modules/pangea_pcieinf_driver/target/*.so >> ${LOG_FILE} 2>&1

systemctl unmask pcieinf.service
systemctl enable pcieinf.service

echo "" >> ${LOG_FILE}
echo "Note that the new pcie driver will take effect AFTER REBOOTING OS!" >> ${LOG_FILE}

exit 0
