#!/usr/bin/env bash
G_DRIVER_NAME="pangea-hisisas-driver-euler-1.09.40.aarch64"
DRIVER_PATH="/usr/lib/modules/pangea_sas"
ARCH=$(uname -i)

STATUS_OK=0
STATUS_FAIL=1
STATUS_NOT_MATCH=2
STATUS_NO_FILE=3
RPM_POST_FAILED_FLAG="RPM_POST_FAILED"

RPM=$(which rpm 2>/dev/null)
if [ -z "${RPM}" ]; then
    echo "Please install rpm package to continue"
    exit ${STATUS_NO_FILE}
fi

# ¼־
function operate_log()
{
    echo "[$(date '+%Y-%m-%d %H:%M:%S')][$1]" >> ${G_OPERATE_LOG}
}

# 
function pangea_upgrade_progress()
{
    echo "$1" > ${G_PROGRESS_RATE_FILE}
}

function insmod_ko()
{
    if [ -f "${DRIVER_PATH}/$1" ]; then
        insmod ${DRIVER_PATH}/$1
    else
        operate_log "Can't find $1"
    fi
}

# SAS.koϢ
function pangea_insmod_sasko()
{
    local L_Int_Index=0

    operate_log "Current filling begin install pangea sas ko."

    SCSI_PATH=/lib/modules/$(uname -r)/kernel/drivers/scsi
    if [ $(lsmod | grep scsi_transport_sas | wc -l) -eq 0 ];then
        ls ${SCSI_PATH}/scsi_transport_sas.ko* | xargs insmod
    fi

    # Ѿfast_reg_disk.koҪж
    if [ $(lsmod | grep fast_reg_disk | wc -l) -ne 0 ];then
        rmmod fast_reg_disk
    fi

    # ϴжsal.koĳ
    if [ $(lsmod | grep dam | wc -l) -ne 0 ];then
        rmmod dam
    fi

    insmod_ko "fast_reg_disk.ko"
    insmod_ko "dam.ko"
    # ˴sal.koȻ
    insmod_ko "sal.ko"
    insmod_ko "gluon.ko"

    if [ ${ARCH} == "aarch64" ]; then
        insmod_ko "higgsv2.ko"
    else
        insmod_ko "quark.ko"
    fi

    operate_log "Current filling end install pangea sas ko."
    sleep 1
    for((L_Int_Index=1; L_Int_Index<5; L_Int_Index++))
    do
        if [ $(lsscsi |grep enclosu |wc -l) -ne 0 ]; then
            operate_log "Expander has coming while loop:${L_Int_Index}."
            sleep 3
            break
        fi
        sleep 1
    done
}


# װ°汾
function pangea_sas_install()
{
    operate_log "Install pangea sas rpms start..."
    if [ ! -f ${G_ROOT_DIR}/${G_DRIVER_NAME}.rpm ]; then
        operate_log "Install failed, no pangea sas driver found!!!"
        return ${STATUS_NO_FILE}
    fi
    rpm_install_log="${G_RPM_LOG}_install"
    ${RPM} -ivh ${G_ROOT_DIR}/${G_DRIVER_NAME}.rpm > ${rpm_install_log} 2>&1
    rpm_install_ret=$?
    cat ${rpm_install_log} >> ${G_RPM_LOG}
    if [ ${rpm_install_ret} -ne ${STATUS_OK} ]; then
        operate_log "Install pangea sas failed."
        rm ${rpm_install_log} -rf
        return ${STATUS_FAIL}
    fi
    # rpmpost׶η̶ֵɹʴ˴ͨжǷɹ
    local fail_check=$(cat ${rpm_install_log} | grep ${RPM_POST_FAILED_FLAG} | wc -l)
    rm ${rpm_install_log} -rf
    if [ ${fail_check} -ne ${STATUS_OK} ]; then
        operate_log "Install pangea sas failed."
        return ${STATUS_FAIL}
    fi

    #ǰsal.koһΰװʱҪֶѷֹSES޷
    if [ $(lsmod | grep sal | wc -l) -eq 0 ]; then
        pangea_insmod_sasko
    fi

    operate_log "Install pangea sas succeed."
    return ${STATUS_OK}
}

# жػѰװ
function pangea_sas_uninstall()
{
    operate_log "Uninstall pangea sas rpms start..."

    pangeasas_prv=$(${RPM} -qa | grep -E "pangea-hisisas-driver|pangea-sas-driver")
    if [ -n "${pangeasas_prv}" ];then
        rpm_uninstall_log="${G_RPM_LOG}_uninstall"
        ${RPM} -e --nodeps ${pangeasas_prv} > ${rpm_uninstall_log} 2>&1
        rpm_uninstall_ret=$?
        cat ${rpm_uninstall_log} >> ${G_RPM_LOG}
        if [ ${rpm_uninstall_ret} -ne ${STATUS_OK} ];then
            operate_log "uninstall ${pangeasas_prv} fail!"
            rm ${rpm_uninstall_log} -rf
            return ${STATUS_FAIL}
        fi
        # ʱļв鿴ʧܱ, ѯһʧܱ
        local fail_check=$(cat ${rpm_uninstall_log} | grep ${RPM_POST_FAILED_FLAG} | wc -l)
        local mkinitrd_check=$(cat $rpm_uninstall_log | grep "mkinitrd: command not found" | wc -l)
        # ʹɾʱļ
        rm ${rpm_uninstall_log} -rf
        if [ ${fail_check} -ne ${STATUS_OK} ];then
            # UVPҪ֧OS汾, Ϊûmkinitrd, ˵OS, Աʧ
            if [ ${mkinitrd_check} -ne ${STATUS_OK} ];then
                operate_log "mkinitrd command not found, uninstall $pangeasas_prv success!"
                return $STATUS_OK
            else
                operate_log "uninstall ${pangeasas_prv} fail!"
                return ${STATUS_FAIL}
            fi
        else
            operate_log "uninstall ${pangeasas_prv} success!"
            return ${STATUS_OK}
        fi
    else
        operate_log "No pangea sas driver find in current OS."
        return ${STATUS_OK}
    fi
}

# 
function pangea_sas_upgrade()
{
    cd ${G_ROOT_DIR}
    pangea_upgrade_progress "upgrading 1"

    pangea_sas_uninstall
    if [ $? -ne ${STATUS_OK} ]; then
        pangea_upgrade_progress "failure"
        return ${STATUS_FAIL}
    fi
    pangea_upgrade_progress "upgrading 50"

    pangea_sas_install
    if [ $? -ne ${STATUS_OK} ]; then
        pangea_upgrade_progress "failure"
        return ${STATUS_FAIL}
    fi
    pangea_upgrade_progress "success"

    return ${STATUS_OK}
}

function main()
{
    operate_log "ready to upgrade sas rpm..."
    pangea_sas_upgrade
}

main
exit $?
