#!/bin/bash

root_dir="$(dirname $(readlink -f $(dirname $0)))"
rpm_dir="$root_dir/repo"
#生产安装标准路径，不能随意修改
LOG_PATH="/var/log/pangea_internal_upgrade/"
LOG_FILE="/var/log/pangea_internal_upgrade/base_upgrade.log"

function log()
{
	if [ ! -d "$LOG_PATH" ]; then
		mkdir "$LOG_PATH"
	fi

	if [ ! -f "$LOG_FILE" ]; then
		touch "$LOG_FILE"
	fi

	chmod 640 "$LOG_FILE"
	echo "$(date +"[%Y-%m-%d %H:%M:%S,%N]") [$0:${BASH_LINENO}] [$1]: [PCIEINF] $2" >> ${LOG_FILE}
}

#设置升级进度
function set_process()
{
    cd $root_dir/action
    if [ ! -e "process.txt" ]; then
        echo "$1%" > process.txt
    fi
	chmod 640 process.txt
    echo "$1%" > process.txt
    log "INFO" "install rpm current process $1."
}

SUPPORT_ENVIR="STL6SPCM STL6SPCN STL6SPCO STL6SPCIA STL6IEX2F001 STL6IEC2F001 STL6SPCY STL6SPCX STL6SPCY44 STL6SPCY55 \
STL6SPCH01 STL6SPCH02 STL6SPCY91 STL6SPCY92"
PCIEINF_RPM_NAME="pangea-pcieinf-drv-euler"
BSP_RPM_NAME="pangea-bsp-drv-euler"
CMA_RPM_NAME="pangea-cma-drv-euler"
PCIEEP_RPM_NAME="pangea-pcieep-drv-euler"
# 下列约束条件 rpm的 install 和 uninstall 的顺序是相反的
# RPM包默认配置
DEFAULT_RPMS_UNINSTALL_LIST="$PCIEINF_RPM_NAME $BSP_RPM_NAME"
DEFAULT_RPMS_INSTALL_LIST="$BSP_RPM_NAME $PCIEINF_RPM_NAME"
# 815及其以后版本内核态升级不升级也不卸载MEMFKNL，由用户态主动去加卸载KO，避免回退到8.1.3版本找不到MEMFKNL驱动
# 太平洋
STL6SPCM_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCM_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
# 大西洋
STL6SPCN_RPMS_UNINSTALL_LIST="$DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCN_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST"
# 北冰洋
STL6SPCO_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCO_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
# DPU
STL6SPCIA_RPMS_UNINSTALL_LIST="$PCIEEP_RPM_NAME $CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCIA_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME $PCIEEP_RPM_NAME"
STL6IEX2F001_RPMS_UNINSTALL_LIST="$STL6SPCIA_RPMS_UNINSTALL_LIST"
STL6IEX2F001_RPMS_INSTALL_LIST="$STL6SPCIA_RPMS_INSTALL_LIST"
STL6IEC2F001_RPMS_UNINSTALL_LIST="$STL6SPCIA_RPMS_UNINSTALL_LIST"
STL6IEC2F001_RPMS_INSTALL_LIST="$STL6SPCIA_RPMS_INSTALL_LIST"
# 东海
STL6SPCY_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCY_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
STL6SPCX_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCX_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
STL6SPCY44_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCY44_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
STL6SPCY55_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCY55_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
STL6SPCH01_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCH01_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
STL6SPCH02_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCH02_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"

# 2U HDD介质框
STL6SPCY91_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCY91_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"
STL6SPCY92_RPMS_UNINSTALL_LIST="$CMA_RPM_NAME $DEFAULT_RPMS_UNINSTALL_LIST"
STL6SPCY92_RPMS_INSTALL_LIST="$DEFAULT_RPMS_INSTALL_LIST $CMA_RPM_NAME"

# 通用服务器没有特定的型号，如果找不到以上型号就认为是taishan服务器
GENERAL_SERVER_RPMS_UNINSTALL_LIST=""
GENERAL_SERVER_RPMS_INSTALL_LIST=""

function upgrade_process()
{
    cd "$rpm_dir"
    # 如果不是$SUPPORT_ENVIR中的环境，默认为通用服务器
    rpms_install_list=$GENERAL_SERVER_RPMS_INSTALL_LIST
    rpms_uninstall_list=$GENERAL_SERVER_RPMS_UNINSTALL_LIST
    cur_envir=$(dmidecode -t2 | awk '/Product Name:/ {print $NF}')
    for envir in $SUPPORT_ENVIR; do
        if [ $envir = $cur_envir ]; then
            rpms_install_list=$(eval echo \${${cur_envir}_RPMS_INSTALL_LIST})
            rpms_uninstall_list=$(eval echo \${${cur_envir}_RPMS_UNINSTALL_LIST})
            break
        fi
    done
    log "INFO" "rpms_install_list $rpms_install_list."
    log "INFO" "rpms_uninstall_list $rpms_uninstall_list."

    log "INFO" "Update base rpms start."
    #uninstall
    for rpm_pkg in $rpms_uninstall_list;
    do
        result=$(rpm -qa | grep $rpm_pkg)
        if [ -n "$result" ]; then
            rpm -e $result --nodeps >> ${LOG_FILE} 2>&1
            if [ $? -ne 0 ]; then
                log "ERR" "rpm uninstall $rpm_pkg failed, ret=$?."
                set_process "failure"
                return 1
            fi
        fi
    done
    set_process "upgrading 25"
    #install
    cd $rpm_dir
    for rpm_pkg in $rpms_install_list;
    do
        rpm -ivh $rpm_pkg*.rpm --nodeps --force >> ${LOG_FILE} 2>&1
        if [ $? -ne 0 ]; then
            log "ERR" "rpm install $rpm_pkg failed, ret=$?."
            set_process "failure"
            return 1
        fi
    done
    set_process "upgrading 75"
    sleep 2

    for rpm_pkg in $rpms_install_list;
    do
        result=$(rpm -qa | grep $rpm_pkg)
        if [ -z "$result" ]; then
            log "ERR" "Check install rpm $rpm_pkg failed."
            set_process "failure"
            return 1
        fi
    done
    set_process "upgrading 90"

    if [ ! -e $root_dir/base_getversion.sh ]; then
        operate_log "can not find $root_dir/base_getversion.sh!"
        return 1
    fi
    cp $root_dir/base_getversion.sh /usr/bin -rf
    dos2unix /usr/bin/base_getversion.sh
    chmod 550 /usr/bin/base_getversion.sh

    mkdir -p /usr/local/pangea_base
    cp $root_dir/version.xml /usr/local/pangea_base/base_knl_version.xml -rf
    set_process "upgrading 100"
    set_process "success"
    log "INFO" "Update base rpms end successfully"
    return 0
}

#更新版本
function upgrade_version()
{
    upgrade_process
}


if ! upgrade_version; then
    log "INFO" "upgrade version failure"
    return 1
fi