#!/usr/bin/env bash
# install pkg
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

###########################################################################

###########################################################################

# 查询环境版本号
function getver()
{
    local check_ret
    local pkg="${board_pkg_table[${PRODUCT_NAME}]}"

    if [[ -z ${pkg} ]];then
        print NOT_MATCH
        operate_log "HARDWARE_TYPE=${HARDWARE_TYPE} not support"
        exit ${STATUS_ENVIRONMENT_NOT_MATCH}
    fi

    deploy_board_pkg "${pkg}"
    check_ret=$?
    if [[ $check_ret != 0 ]]; then
        print "deploy ${pkg} fail, ret:$check_ret"
        exit $check_ret
    fi

    result=$(sh ${PKG_DIR[${pkg}]}/install.sh getver ${WORK_DIR} 2>&1)
    check_ret=$?
    print "$result"
    exit $check_ret
}

# 升级驱动固件包
function upgrade()
{
    local check_ret
    local pkg="${board_pkg_table[${PRODUCT_NAME}]}"

    if [[ -z ${pkg} ]];then
        print "failure: not support board:${HARDWARE_TYPE}"
        exit ${STATUS_ENVIRONMENT_NOT_MATCH}
    fi

    deploy_board_pkg "${pkg}"
    check_ret=$?
    if [[ $check_ret != 0 ]]; then
        print "failure:deploy ${pkg} fail, ret:$check_ret"
        exit $check_ret
    fi

    result=$(sh ${PKG_DIR[${pkg}]}/install.sh upgrade ${WORK_DIR} 2>&1)
    check_ret=$?
    print "$result"
    exit $check_ret
}

# 查询升级进度
function get_progress()
{
    local time=0
    while(( time <= 10 )); do
        if [ -f $PROGRESS_RATE_FILE ]; then
            PROGRESS_RATE=$(cat $PROGRESS_RATE_FILE)
            [[ $PROGRESS_RATE == "success" || $PROGRESS_RATE =~ "upgrading" || $PROGRESS_RATE =~ "failure" ]] && print "$PROGRESS_RATE"
            [[ $? == $STATUS_OK ]] && exit $STATUS_OK
        fi
        sleep 1
        ((time++))
    done

    exit $STATUS_FAIL
}

function init()
{
    HARDWARE_TYPE=$(dmidecode -t2 | awk '/Product Name:/ {print $NF}')
    PRODUCT_NAME=${board_table[$HARDWARE_TYPE]}
}

function main()
{
    local input=$1

    exec 3>&1 4>&2 1>/dev/null 2>&1

    source ${WORK_DIR}/install_lib.sh

    init

    case $input in
        getver)              getver;;
        upgrade)             upgrade;;
        getupgraderate)      get_progress;;
        *)                   help $input;;
    esac
}
###########################################################################

###########################################################################
# 全局变量区：作用于整个脚本的变量，包括路径、文件名、环境变量
# 局部变量切勿与全局变量重名

declare -g WORK_DIR="$(dirname $(readlink -f $0))"
declare -Ag PKG_DIR
declare -g HARDWARE_TYPE
declare -g PRODUCT_NAME
declare -Ag board_table
declare -Ag board_pkg_table

board_table[STL6SPCN]="atlantic"
board_table[STL6SPCY]="dh"
board_table[STL6SPCX]="dh"
board_table[STL6SPCY55]="dh"
board_table[STL6SPCY44]="dh"
board_table[STL6SPCH01]="dh"
board_table[STL6SPCH02]="dh"
board_table[STL6SPCY91]="sn"
board_table[STL6SPCY92]="sn"

board_pkg_table[atlantic]="board-atlantic"
board_pkg_table[dh]="board-dh"
board_pkg_table[sn]="board-sn"

###########################################################################

main "$@"
exit 0

