#!/bin/bash

root_dir="$(dirname $(readlink -f $(dirname $0)))"
rpm_dir="$root_dir/repo"
os_version=$(uname -r | cut -d - -f 1)
#生产安装标准路径，不能随意修改
LOG_PATH="/var/log/pangea_internal_upgrade/"
LOG_FILE="/var/log/pangea_internal_upgrade/idm_upgrade.log"
os_type="euler"

function log()
{
    if [ ! -d "$LOG_PATH" ]; then
        mkdir "$LOG_PATH" 
    fi 

    if [ ! -f "$LOG_FILE" ]; then
        touch "$LOG_FILE" 
    fi 

    chmod 640 "$LOG_FILE" 
    echo "$(date +"[%Y-%m-%d %H:%M:%S,%N]") [$0:${BASH_LINENO}] [$1]: [DMI] $2" >> ${LOG_FILE}
}

#设置升级进度
function set_process()
{
    cd $root_dir/action
    if [ ! -e "process.txt" ]; then
        echo "$1%" > process.txt
    fi
    chmod 640 process.txt
    echo "$1%" > process.txt
    log "INFO" "install rpm current process $1."
}

function upgrade_process()
{
    cd "$rpm_dir"
    #dmi加载和卸载对应的rpm包
    rpms_install_list="pangea-idm-${os_type}-$os_version "
    log "INFO" "Update idm rpms start."

    #uninstall
    installed_rpms=$(rpm -qa | grep "pangea-idm-${os_type}")

    # 遍历并卸载找到的rpm包
    for rpm_pkg in $installed_rpms; do
        rpm -e "$rpm_pkg" --nodeps >> ${LOG_FILE} 2>&1
        if [ $? -ne 0 ]; then
            log "ERR" "rpm uninstall $rpm_pkg failed, ret=$?."
            set_process "failure"
            return 1
        fi
    done
    set_process "upgrading 25"
    #install
    cd $rpm_dir
    for rpm_pkg in $rpms_install_list; do
        rpm -ivh $rpm_pkg*.rpm --nodeps --force >> ${LOG_FILE} 2>&1
        if [ $? -ne 0 ]; then
            log "ERR" "rpm install $rpm_pkg failed, ret=$?."
            set_process "failure"
            return 1
        fi
    done
    set_process "upgrading 75"
    sleep 2

    for rpm_pkg in $rpms_install_list; do
        result=$(rpm -qa | grep $rpm_pkg)
        if [ -z "$result" ]; then
            log "ERR" "Check install rpm $rpm_pkg failed."
            set_process "failure"
            return 1
        fi
    done
    set_process "upgrading 100"
    set_process "success"
    log "INFO" "Update idm rpms end successfully."
    return 0
}

#更新版本
function upgrade_version()
{
    upgrade_process
}

upgrade_version
if [ $? -ne 0 ]; then
    log "ERR" "upgrade version failure."
    return 1
fi
