/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PKCS12Attribute;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.pkcs12.MacData;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final String[] KEY_PROTECTION_ALGORITHM = new String[]{"keystore.pkcs12.keyProtectionAlgorithm", "keystore.PKCS12.keyProtectionAlgorithm"};
    private static final int MAX_ITERATION_COUNT = 5000000;
    private static final int PBE_ITERATION_COUNT = 50000;
    private static final int MAC_ITERATION_COUNT = 100000;
    private static final int SALT_LEN = 20;
    private static final String[] CORE_ATTRIBUTES = new String[]{"1.2.840.113549.1.9.20", "1.2.840.113549.1.9.21", "2.16.840.1.113894.746875.1.1"};
    private static final Debug debug = Debug.getInstance("pkcs12");
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] certBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] secretBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 5};
    private static final int[] pkcs9Name = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] pkcs9KeyId = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static final int[] pkcs9certType = new int[]{1, 2, 840, 113549, 1, 9, 22, 1};
    private static final int[] pbeWithSHAAnd40BitRC2CBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 6};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static final int[] pbes2 = new int[]{1, 2, 840, 113549, 1, 5, 13};
    private static final int[] TrustedKeyUsage = new int[]{2, 16, 840, 1, 113894, 746875, 1, 1};
    private static final int[] AnyExtendedKeyUsage = new int[]{2, 5, 29, 37, 0};
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier CertBag_OID;
    private static ObjectIdentifier SecretBag_OID;
    private static ObjectIdentifier PKCS9FriendlyName_OID;
    private static ObjectIdentifier PKCS9LocalKeyId_OID;
    private static ObjectIdentifier PKCS9CertType_OID;
    private static ObjectIdentifier pbeWithSHAAnd40BitRC2CBC_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private static ObjectIdentifier pbes2_OID;
    private static ObjectIdentifier TrustedKeyUsage_OID;
    private static ObjectIdentifier[] AnyUsage;
    private int counter = 0;
    private int privateKeyCount = 0;
    private int secretKeyCount = 0;
    private int certificateCount = 0;
    private SecureRandom random;
    private Map<String, Entry> entries = Collections.synchronizedMap(new LinkedHashMap());
    private ArrayList<KeyEntry> keyList = new ArrayList();
    private LinkedHashMap<X500Principal, X509Certificate> certsMap = new LinkedHashMap();
    private ArrayList<CertEntry> certEntries = new ArrayList();

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AlgorithmParameters algorithmParameters;
        ObjectIdentifier objectIdentifier;
        Object object;
        Object object2;
        byte[] byArray;
        Object object3;
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        Key key = null;
        if (entry == null || !(entry instanceof KeyEntry)) {
            return null;
        }
        byte[] byArray2 = null;
        if (entry instanceof PrivateKeyEntry) {
            byArray2 = ((PrivateKeyEntry)entry).protectedPrivKey;
        } else if (entry instanceof SecretKeyEntry) {
            byArray2 = ((SecretKeyEntry)entry).protectedSecretKey;
        } else {
            throw new UnrecoverableKeyException("Error locating key");
        }
        try {
            object3 = new EncryptedPrivateKeyInfo(byArray2);
            byArray = ((EncryptedPrivateKeyInfo)object3).getEncryptedData();
            object2 = new DerValue(((EncryptedPrivateKeyInfo)object3).getAlgorithm().encode());
            object = ((DerValue)object2).toDerInputStream();
            objectIdentifier = ((DerInputStream)object).getOID();
            algorithmParameters = this.parseAlgParameters(objectIdentifier, (DerInputStream)object);
        }
        catch (IOException iOException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
            unrecoverableKeyException.initCause(iOException);
            throw unrecoverableKeyException;
        }
        try {
            Object object4;
            Object object5;
            int n = 0;
            if (algorithmParameters != null) {
                try {
                    object3 = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new IOException("Invalid PBE algorithm parameters");
                }
                n = ((PBEParameterSpec)object3).getIterationCount();
                if (n > 5000000) {
                    throw new IOException("PBE iteration count too large");
                }
            }
            while (true) {
                try {
                    object5 = this.getPBEKey(cArray);
                    object4 = Cipher.getInstance(PKCS12KeyStore.mapPBEParamsToAlgorithm(objectIdentifier, algorithmParameters));
                    ((Cipher)object4).init(2, (Key)object5, algorithmParameters);
                    object = ((Cipher)object4).doFinal(byArray);
                }
                catch (Exception exception) {
                    if (cArray.length == 0) {
                        cArray = new char[1];
                        continue;
                    }
                    throw exception;
                }
                break;
            }
            object5 = new DerValue((byte[])object);
            object4 = ((DerValue)object5).toDerInputStream();
            int n2 = ((DerInputStream)object4).getInteger();
            DerValue[] derValueArray = ((DerInputStream)object4).getSequence(2);
            if (derValueArray.length < 1 || derValueArray.length > 2) {
                throw new IOException("Invalid length for AlgorithmIdentifier");
            }
            AlgorithmId algorithmId = new AlgorithmId(derValueArray[0].getOID());
            String string2 = algorithmId.getName();
            if (entry instanceof PrivateKeyEntry) {
                KeyFactory keyFactory = KeyFactory.getInstance(string2);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object);
                key = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                if (debug != null) {
                    debug.println("Retrieved a protected private key at alias '" + string + "' (" + new AlgorithmId(objectIdentifier).getName() + " iterations: " + n + ")");
                }
            } else {
                byte[] byArray3 = ((DerInputStream)object4).getOctetString();
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, string2);
                if (string2.startsWith("PBE")) {
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
                    KeySpec keySpec = secretKeyFactory.getKeySpec(secretKeySpec, PBEKeySpec.class);
                    key = secretKeyFactory.generateSecret(keySpec);
                } else {
                    key = secretKeySpec;
                }
                if (debug != null) {
                    debug.println("Retrieved a protected secret key at alias '" + string + "' (" + new AlgorithmId(objectIdentifier).getName() + " iterations: " + n + ")");
                }
            }
        }
        catch (Exception exception) {
            object2 = new UnrecoverableKeyException("Get Key failed: " + exception.getMessage());
            ((Throwable)object2).initCause(exception);
            throw object2;
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (entry != null && entry instanceof PrivateKeyEntry) {
            if (((PrivateKeyEntry)entry).chain == null) {
                return null;
            }
            if (debug != null) {
                debug.println("Retrieved a " + ((PrivateKeyEntry)entry).chain.length + "-certificate chain at alias '" + string + "'");
            }
            return (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (entry == null) {
            return null;
        }
        if (entry instanceof CertEntry && ((CertEntry)entry).trustedKeyUsage != null) {
            if (debug != null) {
                if (Arrays.equals(AnyUsage, ((CertEntry)entry).trustedKeyUsage)) {
                    debug.println("Retrieved a certificate at alias '" + string + "' (trusted for any purpose)");
                } else {
                    debug.println("Retrieved a certificate at alias '" + string + "' (trusted for limited purposes)");
                }
            }
            return ((CertEntry)entry).cert;
        }
        if (entry instanceof PrivateKeyEntry) {
            if (((PrivateKeyEntry)entry).chain == null) {
                return null;
            }
            if (debug != null) {
                debug.println("Retrieved a certificate at alias '" + string + "'");
            }
            return ((PrivateKeyEntry)entry).chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            return new Date(entry.date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
        try {
            this.setKeyEntry(string, key, passwordProtection, certificateArray, null);
        }
        finally {
            try {
                passwordProtection.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
    }

    private void setKeyEntry(String string, Key key, KeyStore.PasswordProtection passwordProtection, Certificate[] certificateArray, Set<KeyStore.Entry.Attribute> set) throws KeyStoreException {
        try {
            KeyEntry keyEntry;
            if (key instanceof PrivateKey) {
                PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                privateKeyEntry.date = new Date();
                if (key.getFormat().equals("PKCS#8") || key.getFormat().equals("PKCS8")) {
                    if (debug != null) {
                        debug.println("Setting a protected private key at alias '" + string + "'");
                    }
                } else {
                    throw new KeyStoreException("Private key is not encodedas PKCS#8");
                }
                privateKeyEntry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), passwordProtection);
                if (certificateArray != null) {
                    if (certificateArray.length > 1 && !this.validateChain(certificateArray)) {
                        throw new KeyStoreException("Certificate chain is not valid");
                    }
                    privateKeyEntry.chain = (Certificate[])certificateArray.clone();
                    this.certificateCount += certificateArray.length;
                    if (debug != null) {
                        debug.println("Setting a " + certificateArray.length + "-certificate chain at alias '" + string + "'");
                    }
                }
                ++this.privateKeyCount;
                keyEntry = privateKeyEntry;
            } else if (key instanceof SecretKey) {
                SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                secretKeyEntry.date = new Date();
                DerOutputStream derOutputStream = new DerOutputStream();
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(0);
                AlgorithmId algorithmId = AlgorithmId.get(key.getAlgorithm());
                algorithmId.encode(derOutputStream2);
                derOutputStream2.putOctetString(key.getEncoded());
                derOutputStream.write((byte)48, derOutputStream2);
                secretKeyEntry.protectedSecretKey = this.encryptPrivateKey(derOutputStream.toByteArray(), passwordProtection);
                if (debug != null) {
                    debug.println("Setting a protected secret key at alias '" + string + "'");
                }
                ++this.secretKeyCount;
                keyEntry = secretKeyEntry;
            } else {
                throw new KeyStoreException("Unsupported Key type");
            }
            keyEntry.attributes = new HashSet<KeyStore.Entry.Attribute>();
            if (set != null) {
                keyEntry.attributes.addAll(set);
            }
            keyEntry.keyId = ("Time " + keyEntry.date.getTime()).getBytes("UTF8");
            keyEntry.alias = string.toLowerCase(Locale.ENGLISH);
            this.entries.put(string.toLowerCase(Locale.ENGLISH), keyEntry);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key protection  algorithm not found: " + exception, exception);
        }
    }

    @Override
    public synchronized void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw new KeyStoreException("Private key is not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException, iOException);
        }
        PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
        privateKeyEntry.date = new Date();
        if (debug != null) {
            debug.println("Setting a protected private key at alias '" + string + "'");
        }
        try {
            privateKeyEntry.keyId = ("Time " + privateKeyEntry.date.getTime()).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        privateKeyEntry.alias = string.toLowerCase(Locale.ENGLISH);
        privateKeyEntry.protectedPrivKey = (byte[])byArray.clone();
        if (certificateArray != null) {
            if (certificateArray.length > 1 && !this.validateChain(certificateArray)) {
                throw new KeyStoreException("Certificate chain is not valid");
            }
            privateKeyEntry.chain = (Certificate[])certificateArray.clone();
            this.certificateCount += certificateArray.length;
            if (debug != null) {
                debug.println("Setting a " + privateKeyEntry.chain.length + "-certificate chain at alias '" + string + "'");
            }
        }
        ++this.privateKeyCount;
        this.entries.put(string.toLowerCase(Locale.ENGLISH), privateKeyEntry);
    }

    private byte[] getSalt() {
        byte[] byArray = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray);
        return byArray;
    }

    private AlgorithmParameters getPBEAlgorithmParameters(String string) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.getSalt(), 50000);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            throw new IOException("getPBEAlgorithmParameters failed: " + exception.getMessage(), exception);
        }
        return algorithmParameters;
    }

    private AlgorithmParameters parseAlgParameters(ObjectIdentifier objectIdentifier, DerInputStream derInputStream) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        try {
            DerValue derValue;
            if (derInputStream.available() == 0) {
                derValue = null;
            } else {
                derValue = derInputStream.getDerValue();
                if (derValue.tag == 5) {
                    derValue = null;
                }
            }
            if (derValue != null) {
                algorithmParameters = objectIdentifier.equals((Object)pbes2_OID) ? AlgorithmParameters.getInstance("PBES2") : AlgorithmParameters.getInstance("PBE");
                algorithmParameters.init(derValue.toByteArray());
            }
        }
        catch (Exception exception) {
            throw new IOException("parseAlgParameters failed: " + exception.getMessage(), exception);
        }
        return algorithmParameters;
    }

    private SecretKey getPBEKey(char[] cArray) throws IOException {
        SecretKey secretKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            pBEKeySpec.clearPassword();
        }
        catch (Exception exception) {
            throw new IOException("getSecretKey failed: " + exception.getMessage(), exception);
        }
        return secretKey;
    }

    private byte[] encryptPrivateKey(byte[] byArray, KeyStore.PasswordProtection passwordProtection) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray2 = null;
        try {
            AlgorithmParameters algorithmParameters;
            Object object;
            String string = passwordProtection.getProtectionAlgorithm();
            if (string != null) {
                object = passwordProtection.getProtectionParameters();
                if (object != null) {
                    algorithmParameters = AlgorithmParameters.getInstance(string);
                    algorithmParameters.init((AlgorithmParameterSpec)object);
                } else {
                    algorithmParameters = this.getPBEAlgorithmParameters(string);
                }
            } else {
                string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String string = Security.getProperty(KEY_PROTECTION_ALGORITHM[0]);
                        if (string == null) {
                            string = Security.getProperty(KEY_PROTECTION_ALGORITHM[1]);
                        }
                        return string;
                    }
                });
                if (string == null || string.isEmpty()) {
                    string = "PBEWithSHA1AndDESede";
                }
                algorithmParameters = this.getPBEAlgorithmParameters(string);
            }
            object = PKCS12KeyStore.mapPBEAlgorithmToOID(string);
            if (object == null) {
                throw new IOException("PBE algorithm '" + string + " 'is not supported for key entry protection");
            }
            SecretKey secretKey = this.getPBEKey(passwordProtection.getPassword());
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, (Key)secretKey, algorithmParameters);
            byte[] byArray3 = cipher.doFinal(byArray);
            AlgorithmId algorithmId = new AlgorithmId((ObjectIdentifier)object, cipher.getParameters());
            if (debug != null) {
                debug.println("  (Cipher algorithm: " + cipher.getAlgorithm() + ")");
            }
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmId, byArray3);
            byArray2 = encryptedPrivateKeyInfo.getEncoded();
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Encrypt Private Key failed: " + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return byArray2;
    }

    private static ObjectIdentifier mapPBEAlgorithmToOID(String string) throws NoSuchAlgorithmException {
        if (string.toLowerCase(Locale.ENGLISH).startsWith("pbewithhmacsha")) {
            return pbes2_OID;
        }
        return AlgorithmId.get(string).getOID();
    }

    private static String mapPBEParamsToAlgorithm(ObjectIdentifier objectIdentifier, AlgorithmParameters algorithmParameters) throws NoSuchAlgorithmException {
        if (objectIdentifier.equals((Object)pbes2_OID) && algorithmParameters != null) {
            return algorithmParameters.toString();
        }
        return objectIdentifier.toString();
    }

    @Override
    public synchronized void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.setCertEntry(string, certificate, null);
    }

    private void setCertEntry(String string, Certificate certificate, Set<KeyStore.Entry.Attribute> set) throws KeyStoreException {
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (entry != null && entry instanceof KeyEntry) {
            throw new KeyStoreException("Cannot overwrite own certificate");
        }
        CertEntry certEntry = new CertEntry((X509Certificate)certificate, null, string, AnyUsage, set);
        ++this.certificateCount;
        this.entries.put(string.toLowerCase(Locale.ENGLISH), certEntry);
        if (debug != null) {
            debug.println("Setting a trusted certificate at alias '" + string + "'");
        }
    }

    @Override
    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        Entry entry;
        if (debug != null) {
            debug.println("Removing entry at alias '" + string + "'");
        }
        if ((entry = this.entries.get(string.toLowerCase(Locale.ENGLISH))) instanceof PrivateKeyEntry) {
            PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)entry;
            if (privateKeyEntry.chain != null) {
                this.certificateCount -= privateKeyEntry.chain.length;
            }
            --this.privateKeyCount;
        } else if (entry instanceof CertEntry) {
            --this.certificateCount;
        } else if (entry instanceof SecretKeyEntry) {
            --this.secretKeyCount;
        }
        this.entries.remove(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.entries.keySet());
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        return entry != null && entry instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        return entry != null && entry instanceof CertEntry && ((CertEntry)entry).trustedKeyUsage != null;
    }

    @Override
    public boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        if (clazz == KeyStore.TrustedCertificateEntry.class) {
            return this.engineIsCertificateEntry(string);
        }
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (clazz == KeyStore.PrivateKeyEntry.class) {
            return entry != null && entry instanceof PrivateKeyEntry;
        }
        if (clazz == KeyStore.SecretKeyEntry.class) {
            return entry != null && entry instanceof SecretKeyEntry;
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Certificate certificate2 = null;
        Enumeration<String> enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Entry entry = this.entries.get(string);
            if (entry instanceof PrivateKeyEntry) {
                if (((PrivateKeyEntry)entry).chain != null) {
                    certificate2 = ((PrivateKeyEntry)entry).chain[0];
                }
            } else {
                if (!(entry instanceof CertEntry) || ((CertEntry)entry).trustedKeyUsage == null) continue;
                certificate2 = ((CertEntry)entry).cert;
            }
            if (certificate2 == null || !certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        if (cArray == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(3);
        byte[] byArray = derOutputStream2.toByteArray();
        derOutputStream.write(byArray);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        if (this.privateKeyCount > 0 || this.secretKeyCount > 0) {
            if (debug != null) {
                debug.println("Storing " + (this.privateKeyCount + this.secretKeyCount) + " protected key(s) in a PKCS#7 data");
            }
            object2 = this.createSafeContent();
            object = new ContentInfo((byte[])object2);
            ((ContentInfo)object).encode(derOutputStream4);
        }
        if (this.certificateCount > 0) {
            if (debug != null) {
                debug.println("Storing " + this.certificateCount + " certificate(s) in a PKCS#7 encryptedData");
            }
            object2 = this.createEncryptedData(cArray);
            object = new ContentInfo(ContentInfo.ENCRYPTED_DATA_OID, new DerValue((byte[])object2));
            ((ContentInfo)object).encode(derOutputStream4);
        }
        object2 = new DerOutputStream();
        ((DerOutputStream)object2).write((byte)48, derOutputStream4);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        ContentInfo contentInfo = new ContentInfo((byte[])object);
        contentInfo.encode(derOutputStream3);
        byte[] byArray2 = derOutputStream3.toByteArray();
        derOutputStream.write(byArray2);
        byte[] byArray3 = this.calculateMac(cArray, (byte[])object);
        derOutputStream.write(byArray3);
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.write((byte)48, derOutputStream);
        byte[] byArray4 = derOutputStream5.toByteArray();
        outputStream.write(byArray4);
        outputStream.flush();
    }

    @Override
    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        Entry entry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (protectionParameter == null) {
            if (this.engineIsCertificateEntry(string)) {
                if (entry instanceof CertEntry && ((CertEntry)entry).trustedKeyUsage != null) {
                    if (debug != null) {
                        debug.println("Retrieved a trusted certificate at alias '" + string + "'");
                    }
                    return new KeyStore.TrustedCertificateEntry(((CertEntry)entry).cert, this.getAttributes(entry));
                }
            } else {
                throw new UnrecoverableKeyException("requested entry requires a password");
            }
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            if (this.engineIsCertificateEntry(string)) {
                throw new UnsupportedOperationException("trusted certificate entries are not password-protected");
            }
            if (this.engineIsKeyEntry(string)) {
                KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
                char[] cArray = passwordProtection.getPassword();
                Key key = this.engineGetKey(string, cArray);
                if (key instanceof PrivateKey) {
                    Certificate[] certificateArray = this.engineGetCertificateChain(string);
                    return new KeyStore.PrivateKeyEntry((PrivateKey)key, certificateArray, this.getAttributes(entry));
                }
                if (key instanceof SecretKey) {
                    return new KeyStore.SecretKeyEntry((SecretKey)key, this.getAttributes(entry));
                }
            } else if (!this.engineIsKeyEntry(string)) {
                throw new UnsupportedOperationException("untrusted certificate entries are not password-protected");
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (protectionParameter != null && !(protectionParameter instanceof KeyStore.PasswordProtection)) {
            throw new KeyStoreException("unsupported protection parameter");
        }
        KeyStore.PasswordProtection passwordProtection = null;
        if (protectionParameter != null) {
            passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            if (protectionParameter != null && passwordProtection.getPassword() != null) {
                throw new KeyStoreException("trusted certificate entries are not password-protected");
            }
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.setCertEntry(string, trustedCertificateEntry.getTrustedCertificate(), trustedCertificateEntry.getAttributes());
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            if (passwordProtection == null || passwordProtection.getPassword() == null) {
                throw new KeyStoreException("non-null password required to create PrivateKeyEntry");
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.setKeyEntry(string, privateKeyEntry.getPrivateKey(), passwordProtection, privateKeyEntry.getCertificateChain(), privateKeyEntry.getAttributes());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            if (passwordProtection == null || passwordProtection.getPassword() == null) {
                throw new KeyStoreException("non-null password required to create SecretKeyEntry");
            }
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            this.setKeyEntry(string, secretKeyEntry.getSecretKey(), passwordProtection, null, secretKeyEntry.getAttributes());
            return;
        }
        throw new KeyStoreException("unsupported entry type: " + entry.getClass().getName());
    }

    private Set<KeyStore.Entry.Attribute> getAttributes(Entry entry) {
        Object[] objectArray;
        if (entry.attributes == null) {
            entry.attributes = new HashSet<KeyStore.Entry.Attribute>();
        }
        entry.attributes.add(new PKCS12Attribute(PKCS9FriendlyName_OID.toString(), entry.alias));
        byte[] byArray = entry.keyId;
        if (byArray != null) {
            entry.attributes.add(new PKCS12Attribute(PKCS9LocalKeyId_OID.toString(), Debug.toString(byArray)));
        }
        if (entry instanceof CertEntry && (objectArray = ((CertEntry)entry).trustedKeyUsage) != null) {
            if (objectArray.length == 1) {
                entry.attributes.add(new PKCS12Attribute(TrustedKeyUsage_OID.toString(), ((ObjectIdentifier)objectArray[0]).toString()));
            } else {
                entry.attributes.add(new PKCS12Attribute(TrustedKeyUsage_OID.toString(), Arrays.toString(objectArray)));
            }
        }
        return entry.attributes;
    }

    private byte[] generateHash(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IOException("generateHash failed: " + exception, exception);
        }
        return byArray2;
    }

    private byte[] calculateMac(char[] cArray, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        String string = "SHA1";
        try {
            byte[] byArray3 = this.getSalt();
            Mac mac = Mac.getInstance("HmacPBESHA1");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, 100000);
            SecretKey secretKey = this.getPBEKey(cArray);
            mac.init(secretKey, pBEParameterSpec);
            mac.update(byArray);
            byte[] byArray4 = mac.doFinal();
            MacData macData = new MacData(string, byArray4, byArray3, 100000);
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.write(macData.getEncoded());
            byArray2 = derOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IOException("calculateMac failed: " + exception, exception);
        }
        return byArray2;
    }

    private boolean validateChain(Certificate[] certificateArray) {
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i]).getIssuerX500Principal();
            if (x500Principal2.equals(x500Principal = ((X509Certificate)certificateArray[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        HashSet<Certificate> hashSet = new HashSet<Certificate>(Arrays.asList(certificateArray));
        return hashSet.size() == certificateArray.length;
    }

    private byte[] getBagAttributes(String string, byte[] byArray, Set<KeyStore.Entry.Attribute> set) throws IOException {
        return this.getBagAttributes(string, byArray, null, set);
    }

    private byte[] getBagAttributes(String string, byte[] byArray, ObjectIdentifier[] objectIdentifierArray, Set<KeyStore.Entry.Attribute> set) throws IOException {
        Object object2;
        DerOutputStream derOutputStream;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (string == null && byArray == null && byArray4 == null) {
            return null;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (string != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOID(PKCS9FriendlyName_OID);
            object2 = new DerOutputStream();
            DerOutputStream object3 = new DerOutputStream();
            ((DerOutputStream)object2).putBMPString(string);
            derOutputStream.write((byte)49, (DerOutputStream)object2);
            object3.write((byte)48, derOutputStream);
            byArray3 = object3.toByteArray();
        }
        if (byArray != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOID(PKCS9LocalKeyId_OID);
            object2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            ((DerOutputStream)object2).putOctetString(byArray);
            derOutputStream.write((byte)49, (DerOutputStream)object2);
            derOutputStream3.write((byte)48, derOutputStream);
            byArray2 = derOutputStream3.toByteArray();
        }
        if (objectIdentifierArray != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOID(TrustedKeyUsage_OID);
            object2 = new DerOutputStream();
            DerOutputStream derOutputStream4 = new DerOutputStream();
            for (ObjectIdentifier objectIdentifier : objectIdentifierArray) {
                ((DerOutputStream)object2).putOID(objectIdentifier);
            }
            derOutputStream.write((byte)49, (DerOutputStream)object2);
            derOutputStream4.write((byte)48, derOutputStream);
            byArray4 = derOutputStream4.toByteArray();
        }
        derOutputStream = new DerOutputStream();
        if (byArray3 != null) {
            derOutputStream.write(byArray3);
        }
        if (byArray2 != null) {
            derOutputStream.write(byArray2);
        }
        if (byArray4 != null) {
            derOutputStream.write(byArray4);
        }
        if (set != null) {
            for (KeyStore.Entry.Attribute attribute : set) {
                String string2 = attribute.getName();
                if (CORE_ATTRIBUTES[0].equals(string2) || CORE_ATTRIBUTES[1].equals(string2) || CORE_ATTRIBUTES[2].equals(string2)) continue;
                derOutputStream.write(((PKCS12Attribute)attribute).getEncoded());
            }
        }
        derOutputStream2.write((byte)49, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    private byte[] createEncryptedData(char[] cArray) throws CertificateException, IOException {
        Object object;
        Object object2;
        Object object3;
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object4 = this.engineAliases();
        while (object4.hasMoreElements()) {
            object3 = object4.nextElement();
            object2 = this.entries.get(object3);
            if (object2 instanceof PrivateKeyEntry) {
                PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)object2;
                object = privateKeyEntry.chain != null ? privateKeyEntry.chain : new Certificate[]{};
            } else {
                object = object2 instanceof CertEntry ? new Certificate[]{((CertEntry)object2).cert} : new Certificate[]{};
            }
            for (int i = 0; i < ((Certificate[])object).length; ++i) {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(CertBag_OID);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putOID(PKCS9CertType_OID);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                X509Certificate x509Certificate = (X509Certificate)object[i];
                derOutputStream4.putOctetString(x509Certificate.getEncoded());
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
                DerOutputStream derOutputStream5 = new DerOutputStream();
                derOutputStream5.write((byte)48, derOutputStream3);
                byte[] byArray = derOutputStream5.toByteArray();
                DerOutputStream derOutputStream6 = new DerOutputStream();
                derOutputStream6.write(byArray);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream6);
                byte[] byArray2 = null;
                if (i == 0) {
                    Entry entry;
                    if (object2 instanceof KeyEntry) {
                        entry = (KeyEntry)object2;
                        byArray2 = this.getBagAttributes(entry.alias, entry.keyId, entry.attributes);
                    } else {
                        entry = (CertEntry)object2;
                        byArray2 = this.getBagAttributes(((CertEntry)entry).alias, ((CertEntry)entry).keyId, ((CertEntry)entry).trustedKeyUsage, ((CertEntry)entry).attributes);
                    }
                } else {
                    byArray2 = this.getBagAttributes(x509Certificate.getSubjectX500Principal().getName(), null, ((Entry)object2).attributes);
                }
                if (byArray2 != null) {
                    derOutputStream2.write(byArray2);
                }
                derOutputStream.write((byte)48, derOutputStream2);
            }
        }
        object4 = new DerOutputStream();
        ((DerOutputStream)object4).write((byte)48, derOutputStream);
        object3 = ((ByteArrayOutputStream)object4).toByteArray();
        object2 = this.encryptContent((byte[])object3, cArray);
        object = new DerOutputStream();
        DerOutputStream derOutputStream7 = new DerOutputStream();
        ((DerOutputStream)object).putInteger(0);
        ((OutputStream)object).write((byte[])object2);
        derOutputStream7.write((byte)48, (DerOutputStream)object);
        return derOutputStream7.toByteArray();
    }

    private byte[] createSafeContent() throws CertificateException, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object = this.engineAliases();
        while (object.hasMoreElements()) {
            DerOutputStream derOutputStream2;
            Object object2;
            Object object3;
            String string = object.nextElement();
            Entry entry = this.entries.get(string);
            if (entry == null || !(entry instanceof KeyEntry)) continue;
            DerOutputStream derOutputStream3 = new DerOutputStream();
            KeyEntry keyEntry = (KeyEntry)entry;
            if (keyEntry instanceof PrivateKeyEntry) {
                derOutputStream3.putOID(PKCS8ShroudedKeyBag_OID);
                object3 = ((PrivateKeyEntry)keyEntry).protectedPrivKey;
                object2 = null;
                try {
                    object2 = new EncryptedPrivateKeyInfo((byte[])object3);
                }
                catch (IOException iOException) {
                    throw new IOException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + iOException.getMessage());
                }
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.write(((EncryptedPrivateKeyInfo)object2).getEncoded());
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
            } else {
                if (!(keyEntry instanceof SecretKeyEntry)) continue;
                derOutputStream3.putOID(SecretBag_OID);
                object3 = new DerOutputStream();
                object3.putOID(PKCS8ShroudedKeyBag_OID);
                object2 = new DerOutputStream();
                ((DerOutputStream)object2).putOctetString(((SecretKeyEntry)keyEntry).protectedSecretKey);
                object3.write(DerValue.createTag((byte)-128, true, (byte)0), (DerOutputStream)object2);
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.write((byte)48, (DerOutputStream)object3);
                byte[] byArray = derOutputStream2.toByteArray();
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write(byArray);
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
            }
            object3 = this.getBagAttributes(string, entry.keyId, entry.attributes);
            derOutputStream3.write((byte[])object3);
            derOutputStream.write((byte)48, derOutputStream3);
        }
        object = new DerOutputStream();
        ((DerOutputStream)object).write((byte)48, derOutputStream);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    private byte[] encryptContent(byte[] byArray, char[] cArray) throws IOException {
        Object object;
        Object object2;
        byte[] byArray2 = null;
        AlgorithmParameters algorithmParameters = this.getPBEAlgorithmParameters("PBEWithSHA1AndRC2_40");
        DerOutputStream derOutputStream = new DerOutputStream();
        AlgorithmId algorithmId = new AlgorithmId(pbeWithSHAAnd40BitRC2CBC_OID, algorithmParameters);
        algorithmId.encode(derOutputStream);
        byte[] byArray3 = derOutputStream.toByteArray();
        try {
            object2 = this.getPBEKey(cArray);
            object = Cipher.getInstance("PBEWithSHA1AndRC2_40");
            ((Cipher)object).init(1, (Key)object2, algorithmParameters);
            byArray2 = ((Cipher)object).doFinal(byArray);
            if (debug != null) {
                debug.println("  (Cipher algorithm: " + ((Cipher)object).getAlgorithm() + ")");
            }
        }
        catch (Exception exception) {
            throw new IOException("Failed to encrypt safe contents entry: " + exception, exception);
        }
        object2 = new DerOutputStream();
        ((DerOutputStream)object2).putOID(ContentInfo.DATA_OID);
        ((OutputStream)object2).write(byArray3);
        object = new DerOutputStream();
        ((DerOutputStream)object).putOctetString(byArray2);
        ((DerOutputStream)object2).writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), (DerOutputStream)object);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, (DerOutputStream)object2);
        return derOutputStream2.toByteArray();
    }

    @Override
    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        if (inputStream == null) {
            return;
        }
        this.counter = 0;
        DerValue derValue = new DerValue(inputStream);
        DerInputStream derInputStream = derValue.toDerInputStream();
        int n = derInputStream.getInteger();
        if (n != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        this.entries.clear();
        ContentInfo contentInfo = new ContentInfo(derInputStream);
        ObjectIdentifier objectIdentifier = contentInfo.getContentType();
        if (!objectIdentifier.equals((Object)ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] byArray = contentInfo.getData();
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        int n2 = derValueArray.length;
        this.privateKeyCount = 0;
        this.secretKeyCount = 0;
        this.certificateCount = 0;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2;
            block32: {
                object4 = null;
                object3 = new DerInputStream(derValueArray[i].toByteArray());
                object2 = new ContentInfo((DerInputStream)object3);
                objectIdentifier = ((ContentInfo)object2).getContentType();
                byArray2 = null;
                if (objectIdentifier.equals((Object)ContentInfo.DATA_OID)) {
                    if (debug != null) {
                        debug.println("Loading PKCS#7 data");
                    }
                    byArray2 = ((ContentInfo)object2).getData();
                } else {
                    if (objectIdentifier.equals((Object)ContentInfo.ENCRYPTED_DATA_OID)) {
                        if (cArray == null) {
                            if (debug == null) continue;
                            debug.println("Warning: skipping PKCS#7 encryptedData - no password was supplied");
                            continue;
                        }
                        object = ((ContentInfo)object2).getContent().toDerInputStream();
                        int n3 = ((DerInputStream)object).getInteger();
                        DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(3);
                        if (derValueArray2.length != 3) {
                            throw new IOException("Invalid length for EncryptedContentInfo");
                        }
                        ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                        object4 = derValueArray2[1].toByteArray();
                        if (!derValueArray2[2].isContextSpecific((byte)0)) {
                            throw new IOException("unsupported encrypted content type " + derValueArray2[2].tag);
                        }
                        byte by = 4;
                        if (derValueArray2[2].isConstructed()) {
                            by = (byte)(by | 0x20);
                        }
                        derValueArray2[2].resetTag(by);
                        byArray2 = derValueArray2[2].getOctetString();
                        DerInputStream derInputStream3 = derValueArray2[1].toDerInputStream();
                        ObjectIdentifier objectIdentifier3 = derInputStream3.getOID();
                        AlgorithmParameters algorithmParameters = this.parseAlgParameters(objectIdentifier3, derInputStream3);
                        int n4 = 0;
                        if (algorithmParameters != null) {
                            PBEParameterSpec pBEParameterSpec;
                            try {
                                pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
                            }
                            catch (InvalidParameterSpecException invalidParameterSpecException) {
                                throw new IOException("Invalid PBE algorithm parameters");
                            }
                            n4 = pBEParameterSpec.getIterationCount();
                            if (n4 > 5000000) {
                                throw new IOException("PBE iteration count too large");
                            }
                        }
                        if (debug != null) {
                            debug.println("Loading PKCS#7 encryptedData (" + new AlgorithmId(objectIdentifier3).getName() + " iterations: " + n4 + ")");
                        }
                        while (true) {
                            try {
                                SecretKey secretKey = this.getPBEKey(cArray);
                                Cipher cipher = Cipher.getInstance(objectIdentifier3.toString());
                                cipher.init(2, (Key)secretKey, algorithmParameters);
                                byArray2 = cipher.doFinal(byArray2);
                                break block32;
                            }
                            catch (Exception exception) {
                                if (cArray.length == 0) {
                                    cArray = new char[1];
                                    continue;
                                }
                                throw new IOException("keystore password was incorrect", new UnrecoverableKeyException("failed to decrypt safe contents entry: " + exception));
                            }
                            break;
                        }
                    }
                    throw new IOException("public key protected PKCS12 not supported");
                }
            }
            object = new DerInputStream(byArray2);
            this.loadSafeContents((DerInputStream)object, cArray);
        }
        if (cArray != null && derInputStream.available() > 0) {
            MacData macData = new MacData(derInputStream);
            int n5 = macData.getIterations();
            try {
                if (n5 > 5000000) {
                    throw new InvalidAlgorithmParameterException("MAC iteration count too large: " + n5);
                }
                object2 = macData.getDigestAlgName().toUpperCase(Locale.ENGLISH);
                object2 = ((String)object2).replace("-", "");
                object3 = Mac.getInstance("HmacPBE" + (String)object2);
                object4 = new PBEParameterSpec(macData.getSalt(), n5);
                object = this.getPBEKey(cArray);
                ((Mac)object3).init((Key)object, (AlgorithmParameterSpec)object4);
                ((Mac)object3).update(byArray);
                byte[] byArray3 = ((Mac)object3).doFinal();
                if (debug != null) {
                    debug.println("Checking keystore integrity (" + ((Mac)object3).getAlgorithm() + " iterations: " + n5 + ")");
                }
                if (!MessageDigest.isEqual(macData.getDigest(), byArray3)) {
                    throw new UnrecoverableKeyException("Failed PKCS12 integrity checking");
                }
            }
            catch (Exception exception) {
                throw new IOException("Integrity check failed: " + exception, exception);
            }
        }
        PrivateKeyEntry[] privateKeyEntryArray = this.keyList.toArray(new PrivateKeyEntry[this.keyList.size()]);
        for (int i = 0; i < privateKeyEntryArray.length; ++i) {
            object2 = privateKeyEntryArray[i];
            if (((PrivateKeyEntry)object2).keyId == null) continue;
            object3 = new ArrayList();
            object4 = this.findMatchedCertificate((PrivateKeyEntry)object2);
            block9: while (object4 != null) {
                if (!((ArrayList)object3).isEmpty()) {
                    object = ((ArrayList)object3).iterator();
                    while (object.hasNext()) {
                        X509Certificate x509Certificate = (X509Certificate)object.next();
                        if (!((Certificate)object4).equals(x509Certificate)) continue;
                        if (debug == null) break block9;
                        debug.println("Loop detected in certificate chain. Skip adding repeated cert to chain. Subject: " + ((X509Certificate)object4).getSubjectX500Principal().toString());
                        break block9;
                    }
                }
                ((ArrayList)object3).add(object4);
                object = ((X509Certificate)object4).getIssuerX500Principal();
                if (((X500Principal)object).equals(((X509Certificate)object4).getSubjectX500Principal())) break;
                object4 = this.certsMap.get(object);
            }
            if (((ArrayList)object3).size() <= 0) continue;
            ((PrivateKeyEntry)object2).chain = ((ArrayList)object3).toArray(new Certificate[((ArrayList)object3).size()]);
        }
        if (debug != null) {
            debug.println("PKCS12KeyStore load: private key count: " + this.privateKeyCount + ". secret key count: " + this.secretKeyCount + ". certificate count: " + this.certificateCount);
        }
        this.certEntries.clear();
        this.certsMap.clear();
        this.keyList.clear();
    }

    private X509Certificate findMatchedCertificate(PrivateKeyEntry privateKeyEntry) {
        CertEntry certEntry = null;
        CertEntry certEntry2 = null;
        for (CertEntry certEntry3 : this.certEntries) {
            if (Arrays.equals(privateKeyEntry.keyId, certEntry3.keyId)) {
                certEntry = certEntry3;
                if (!privateKeyEntry.alias.equalsIgnoreCase(certEntry3.alias)) continue;
                return certEntry3.cert;
            }
            if (!privateKeyEntry.alias.equalsIgnoreCase(certEntry3.alias)) continue;
            certEntry2 = certEntry3;
        }
        if (certEntry != null) {
            return certEntry.cert;
        }
        if (certEntry2 != null) {
            return certEntry2.cert;
        }
        return null;
    }

    private void loadSafeContents(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            ObjectIdentifier[] objectIdentifierArray;
            Object object4;
            Object object5;
            Object object6;
            Object object7 = null;
            DerInputStream derInputStream2 = derValueArray[i].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals((Object)PKCS8ShroudedKeyBag_OID)) {
                object6 = new PrivateKeyEntry();
                object6.protectedPrivKey = derValue.toByteArray();
                object7 = object6;
                ++this.privateKeyCount;
            } else if (objectIdentifier.equals((Object)CertBag_OID)) {
                object6 = new DerInputStream(derValue.toByteArray());
                object5 = object6.getSequence(2);
                if (((DerValue[])object5).length != 2) {
                    throw new IOException("Invalid length for CertBag");
                }
                object4 = object5[0].getOID();
                if (!object5[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object5[1].tag);
                }
                objectIdentifierArray = object5[1].data.getDerValue();
                object3 = CertificateFactory.getInstance("X509");
                X509Certificate x509Certificate = (X509Certificate)((CertificateFactory)object3).generateCertificate(new ByteArrayInputStream(objectIdentifierArray.getOctetString()));
                object7 = x509Certificate;
                ++this.certificateCount;
            } else if (objectIdentifier.equals((Object)SecretBag_OID)) {
                object6 = new DerInputStream(derValue.toByteArray());
                object5 = object6.getSequence(2);
                if (((DerValue[])object5).length != 2) {
                    throw new IOException("Invalid length for SecretBag");
                }
                object4 = object5[0].getOID();
                if (!object5[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 secret value type " + object5[1].tag);
                }
                objectIdentifierArray = object5[1].data.getDerValue();
                object3 = new SecretKeyEntry();
                ((SecretKeyEntry)object3).protectedSecretKey = objectIdentifierArray.getOctetString();
                object7 = object3;
                ++this.secretKeyCount;
            } else if (debug != null) {
                debug.println("Unsupported PKCS12 bag type: " + objectIdentifier);
            }
            try {
                object6 = derInputStream2.getSet(3);
            }
            catch (IOException iOException) {
                object6 = null;
            }
            object5 = null;
            object4 = null;
            objectIdentifierArray = null;
            object3 = new HashSet();
            if (object6 != null) {
                for (int j = 0; j < ((DerValue[])object6).length; ++j) {
                    DerValue[] derValueArray2;
                    object2 = object6[j].toByteArray();
                    object = new DerInputStream((byte[])object2);
                    DerValue[] derValueArray3 = ((DerInputStream)object).getSequence(2);
                    if (derValueArray3.length != 2) {
                        throw new IOException("Invalid length for Attribute");
                    }
                    ObjectIdentifier objectIdentifier2 = derValueArray3[0].getOID();
                    DerInputStream derInputStream3 = new DerInputStream(derValueArray3[1].toByteArray());
                    try {
                        derValueArray2 = derInputStream3.getSet(1);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Attribute " + objectIdentifier2 + " should have a value " + iOException.getMessage());
                    }
                    if (objectIdentifier2.equals((Object)PKCS9FriendlyName_OID)) {
                        object5 = derValueArray2[0].getBMPString();
                        continue;
                    }
                    if (objectIdentifier2.equals((Object)PKCS9LocalKeyId_OID)) {
                        object4 = derValueArray2[0].getOctetString();
                        continue;
                    }
                    if (objectIdentifier2.equals((Object)TrustedKeyUsage_OID)) {
                        objectIdentifierArray = new ObjectIdentifier[derValueArray2.length];
                        for (int k = 0; k < derValueArray2.length; ++k) {
                            objectIdentifierArray[k] = derValueArray2[k].getOID();
                        }
                        continue;
                    }
                    object3.add(new PKCS12Attribute((byte[])object2));
                }
            }
            if (object7 instanceof KeyEntry) {
                KeyEntry keyEntry = (KeyEntry)object7;
                if (object7 instanceof PrivateKeyEntry && object4 == null) {
                    if (this.privateKeyCount != 1) continue;
                    object4 = "01".getBytes("UTF8");
                }
                keyEntry.keyId = (byte[])object4;
                object2 = new String((byte[])object4, "UTF8");
                object = null;
                if (object2.startsWith("Time ")) {
                    try {
                        object = new Date(Long.parseLong(object2.substring(5)));
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
                if (object == null) {
                    object = new Date();
                }
                keyEntry.date = object;
                if (object7 instanceof PrivateKeyEntry) {
                    this.keyList.add((PrivateKeyEntry)keyEntry);
                }
                if (keyEntry.attributes == null) {
                    keyEntry.attributes = new HashSet();
                }
                keyEntry.attributes.addAll(object3);
                if (object5 == null) {
                    object5 = this.getUnfriendlyName();
                }
                keyEntry.alias = object5;
                this.entries.put(((String)object5).toLowerCase(Locale.ENGLISH), keyEntry);
                continue;
            }
            if (!(object7 instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)object7;
            if (object4 == null && this.privateKeyCount == 1 && i == 0) {
                object4 = "01".getBytes("UTF8");
            }
            if (objectIdentifierArray != null) {
                if (object5 == null) {
                    object5 = this.getUnfriendlyName();
                }
                object2 = new CertEntry(x509Certificate, (byte[])object4, (String)object5, objectIdentifierArray, (Set<? extends KeyStore.Entry.Attribute>)object3);
                this.entries.put(((String)object5).toLowerCase(Locale.ENGLISH), (Entry)object2);
            } else {
                this.certEntries.add(new CertEntry(x509Certificate, (byte[])object4, (String)object5));
            }
            object2 = x509Certificate.getSubjectX500Principal();
            if (object2 == null || this.certsMap.containsKey(object2)) continue;
            this.certsMap.put((X500Principal)object2, x509Certificate);
        }
    }

    private String getUnfriendlyName() {
        ++this.counter;
        return String.valueOf(this.counter);
    }

    static {
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            CertBag_OID = new ObjectIdentifier(certBag);
            SecretBag_OID = new ObjectIdentifier(secretBag);
            PKCS9FriendlyName_OID = new ObjectIdentifier(pkcs9Name);
            PKCS9LocalKeyId_OID = new ObjectIdentifier(pkcs9KeyId);
            PKCS9CertType_OID = new ObjectIdentifier(pkcs9certType);
            pbeWithSHAAnd40BitRC2CBC_OID = new ObjectIdentifier(pbeWithSHAAnd40BitRC2CBC);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
            pbes2_OID = new ObjectIdentifier(pbes2);
            TrustedKeyUsage_OID = new ObjectIdentifier(TrustedKeyUsage);
            AnyUsage = new ObjectIdentifier[]{new ObjectIdentifier(AnyExtendedKeyUsage)};
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CertEntry
    extends Entry {
        final X509Certificate cert;
        ObjectIdentifier[] trustedKeyUsage;

        CertEntry(X509Certificate x509Certificate, byte[] byArray, String string) {
            this(x509Certificate, byArray, string, null, null);
        }

        CertEntry(X509Certificate x509Certificate, byte[] byArray, String string, ObjectIdentifier[] objectIdentifierArray, Set<? extends KeyStore.Entry.Attribute> set) {
            this.date = new Date();
            this.cert = x509Certificate;
            this.keyId = byArray;
            this.alias = string;
            this.trustedKeyUsage = objectIdentifierArray;
            this.attributes = new HashSet();
            if (set != null) {
                this.attributes.addAll(set);
            }
        }
    }

    private static class SecretKeyEntry
    extends KeyEntry {
        byte[] protectedSecretKey;

        private SecretKeyEntry() {
        }
    }

    private static class PrivateKeyEntry
    extends KeyEntry {
        byte[] protectedPrivKey;
        Certificate[] chain;

        private PrivateKeyEntry() {
        }
    }

    private static class KeyEntry
    extends Entry {
        private KeyEntry() {
        }
    }

    private static class Entry {
        Date date;
        String alias;
        byte[] keyId;
        Set<KeyStore.Entry.Attribute> attributes;

        private Entry() {
        }
    }
}

