var buildTime="2020-10-23 11:02:39";
var timeStamp = buildTime
  ? new Date(buildTime).getTime()
  : new Date().getTime(); // 优化缓存
var BrowserVersionSupport = {
  // TODO:以后单独维护
  SAFARI: 537,
  CHROME: 54,
  FIREFOX: 43,
  IE9: 9,
  IE10: 10
};
function hideIeTip() {
  var tip = document.getElementById('ui-ie-tip');
  if (tip) {
    document.body.removeChild(tip);
  }
}

(function() {
  var isIE = false;

  //css兼容性工具
  var js = document.createElement('script');
  js.onload = function() {
    Modernizr.addTest('ie', isIE);
  };
  js.setAttribute(
    'src',
    'assets/ang/utils/modernizr-custom.min.js?t=' + timeStamp
  );
  document.getElementsByTagName('head')[0].appendChild(js);

  initStaticRes();

  //IE10, chrome54, firefox43 及其以上版本都兼容
  function environmentCheck(title) {
    var value = navigator.userAgent; //取得浏览器的userAgent字符串
    var path = 'assets/page-error.html';
    var origin =
      window.location.protocol +
      '//' +
      window.location.host +
      window.location.pathname;
    var pageError = sessionStorage.getItem('pageError');
    if (pageError == 1) {
      return;
    }

    // Get IE or Edge browser version
    var version = detectIE();
    // onlyChrome 此配置优先判断
    if (window.angConfig.onlyChrome) {
      var directUrl =
        window.angConfig.errorPageUrl || origin + path + '?title=' + title;
      // 判断为chrome 并版本大于指定版本
      var isSupportChrome =
        value.indexOf('Chrome') > 0 &&
        +value
          .toLowerCase()
          .split('chrome/')[1]
          .split('.')[0] >=
          (+window.angConfig.chromeVersion || BrowserVersionSupport.CHROME);
      if (isSupportChrome) {
        return;
      }
      window.location.href = directUrl;
      return;
    }
    if (!version) {
      if (!!value.match(/AppleWebKit.*Mobile.*/)) {
        if (value.indexOf('AppleWebKit') > -1) {
          if (
            Number(value.toLowerCase().split('safari/')[1]) <
            BrowserVersionSupport.SAFARI
          ) {
            window.location.href = origin + path + '?title=' + title;
          }
        }
      } else {
        if (value.indexOf('Chrome') > 0) {
          if (
            Number(
              value
                .toLowerCase()
                .split('chrome/')[1]
                .split('.')[0]
            ) < BrowserVersionSupport.CHROME
          ) {
            window.location.href = origin + path + '?title=' + title;
          }
        } else if (value.indexOf('Firefox') > 0) {
          if (
            Number(
              value
                .toLowerCase()
                .split('firefox/')[1]
                .split('.')[0]
            ) < BrowserVersionSupport.FIREFOX
          ) {
            window.location.href = origin + path + '?title=' + title;
          }
        }
      }
    } else {
      if (window.angConfig.supportIE && version > BrowserVersionSupport.IE9) {
        isIE = true;
        //加入ie浏览器提示
        tipHTML =
          '<div id="ui-ie-tip" class="ui-ie-tip"><div class="ui-ie-tip-content" style="width: 350px">We recommend using the latest Google Chrome browser.' +
          '<span onclick="hideIeTip()" class="ui-ie-tip-close">' +
          '<svg class="icon"><use xlink:href="#icon-close"></use></svg>' +
          '</span></div></div>'; //参照isource的ie提示

        if (window.angConfig.hideBrowserRecommendTip !== true) {
          // [浏览器兼容]解决IE浏览器下svg图标不能加载问题
          insertBody(tipHTML);
        }

        if (
          !window.angConfig.supportIE10 &&
          version == BrowserVersionSupport.IE10
        ) {
          window.location.href =
            origin + '/assets/page-error-ie.html?title=' + title;
        }
      } else {
        window.location.href =
          origin + '/assets/page-error-ie.html?title=' + title;
      }
    }
  }

  /**
     * detect IE
     * returns version of IE or false, if browser is not Internet Explorer
        // Test values; Uncomment to check result …

        // IE 10
        // ua = 'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Trident/6.0)';

        // IE 11
        // ua = 'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko';

        // Edge 12 (Spartan)
        // ua = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.71 Safari/537.36 Edge/12.0';

        // Edge 13
        // ua = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Safari/537.36 Edge/13.10586';
    */
  function detectIE() {
    var ua = window.navigator.userAgent;

    var msie = ua.indexOf('MSIE ');
    if (msie > 0) {
      // IE 10 or older => return version number
      return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
    }

    var trident = ua.indexOf('Trident/');
    if (trident > 0) {
      // IE 11 => return version number
      var rv = ua.indexOf('rv:');
      return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
    }

    var edge = ua.indexOf('Edge/');
    if (edge > 0) {
      // Edge (IE 12+) => return version number
      return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
    }

    // other browser
    return false;
  }

  function getSVGResource(path, index) {
    //查找到第一个id就返回。
    var angHtml = '';
    var request = new XMLHttpRequest();
    request.open('GET', path + '?t=' + timeStamp, true);
    request.send();
    request.onload = function(e) {
      angHtml =
        '<div id="angSVGContent' +
        index +
        '" style="height: 0; width: 0; position: absolute; visibility: hidden">' +
        request.responseText +
        '</div>';

      insertBody(angHtml);
    };
  }

  // 插入元素到Body中
  function insertBody(html) {
    if (document.readyState === 'complete') {
      document.body.insertAdjacentHTML('afterBegin', html);
      return;
    }
    // 兼容文档加载完成后处理
    var originOnLoad = window.onload;
    window.onload = function() {
      if (typeof originOnLoad === 'function') {
        originOnLoad.call(window, arguments);
      }
      document.body.insertAdjacentHTML('afterBegin', html);
    };
  }

  // 插入所有Icon Svg资源
  function insertIconSVGResource() {
    if (!window.angConfig) {
      return;
    }

    // 默认svg路径
    var paths = ['assets/ang/icons/ang.svg'];

    if (window.angConfig.theme === 'aui') {
      paths = ['assets/ang/icons/aui.svg'];
    }

    // 组合所有配置的svg路径
    var configPaths = window.angConfig.svgPath || [];
    paths = paths.concat(configPaths);

    // 组合所有svg Html
    paths.forEach(function(path, index) {
      getSVGResource(path, index);
    });
  }

  function initStaticRes() {
    // window.angConfig初始化
    !window.angConfig && (window.angConfig = Object.create(null));
    window.angConfig.supportIE === void 0 &&
      (window.angConfig.supportIE = true);
    window.angConfig.supportIE10 === void 0 &&
      (window.angConfig.supportIE10 = true);
    window.angConfig.browserLanguage === void 0 &&
      (window.angConfig.browserLanguage = 'en'); // 缺省语言
    window.angConfig.errorPageTitle === void 0 &&
      (window.angConfig.errorPageTitle = 'LIVE UI');
    window.angConfig.domain === void 0 &&
      (window.angConfig.domain = '.huawei.com');

    window.angConfig.svgPath; // 图标路径
    window.angConfig.tableFilterStyle; // 表格筛选模式，可选值为inline和tip
    window.angConfig.autoHeightPanelBottom; // 产品底部（如footer）内容的高度
    // window.angConfig.browserLanguage; // 缺省语言
    window.angConfig.theme; // 主题
    window.angConfig.tableTheme; // 表格主题
    window.angConfig.trimTableSearchValue; // 表格搜索是否过滤空格

    //注册全局变量
    window.ang = {
      version: 'v1.7.47-rc.44',
      buildTime: buildTime
    };

    var html = document.querySelector('html');
    html.setAttribute('ang-version', window.ang.version);
    html.setAttribute('build-time', buildTime);

    environmentCheck(window.angConfig.errorPageTitle);
    polyfill(isIE);

    // 插入所有Icon Svg资源
    insertIconSVGResource();
  }

  //填充库
  function polyfill(isIE) {
    if (isIE) {
      //IE10下无window.location.origin,故新增
      !window.location.origin &&
        (window.location.origin =
          window.location.protocol + '//' + window.location.host);

      //IE10下无widnow.navigator.language,故新增
      !window.navigator.language &&
        (window.navigator.language = window.navigator.browserLanguage);

      //IE下无element.remove(),故新增
      (function(arr) {
        arr.forEach(function(item) {
          if (item.hasOwnProperty('remove')) {
            return;
          }
          Object.defineProperty(item, 'remove', {
            configurable: true,
            enumerable: true,
            writable: true,
            value: function remove() {
              this.parentNode && this.parentNode.removeChild(this);
            }
          });
        });
      })([Element.prototype, CharacterData.prototype, DocumentType.prototype]);

      // NodeList forEach Polyfill
      if (window.NodeList && !NodeList.prototype.forEach) {
        NodeList.prototype.forEach = function(callback, thisArg) {
          thisArg = thisArg || window;
          for (var i = 0; i < this.length; i++) {
            callback.call(thisArg, this[i], i, this);
          }
        };
      }

      // IE下无matches方法，故新增
      if (!Element.prototype.matches) {
        Element.prototype.matches =
          Element.prototype.msMatchesSelector ||
          Element.prototype.webkitMatchesSelector;
      }

      // IE下无closest方法，故新增
      if (!Element.prototype.closest) {
        Element.prototype.closest = function(s) {
          var el = this;

          do {
            if (el.matches(s)) return el;
            el = el.parentElement || el.parentNode;
          } while (el !== null && el.nodeType === 1);
          return null;
        };
      }

      // IE下无includs方法，故新增
      if (!Array.prototype.includes) {
        Object.defineProperty(Array.prototype, 'includes', {
          value: function(valueToFind, fromIndex) {
            if (this == null) {
              throw new TypeError('"this" is null or not defined');
            }

            var o = Object(this);
            var len = o.length >>> 0;

            if (len === 0) {
              return false;
            }

            var n = fromIndex | 0;
            var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);

            function sameValueZero(x, y) {
              return (
                x === y ||
                (typeof x === 'number' &&
                  typeof y === 'number' &&
                  isNaN(x) &&
                  isNaN(y))
              );
            }

            while (k < len) {
              if (sameValueZero(o[k], valueToFind)) {
                return true;
              }
              k++;
            }

            return false;
          }
        });
      }
    }
  }
})();

function hideIeTip() {
  var tip = document.getElementById('ui-ie-tip');
  if (tip) {
    document.body.removeChild(tip);
  }
}
