# -*- coding: utf-8 -*-
"""
Storage 上传软件包
"""
import os
import utils.common.log as logger
from utils.common.exception import FCDException as FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.scripts.implement.TC_Distributed_Upgrade_Pkg \
    import DistributePkg
from plugins.DistributedStorage.scripts.utils.iterm.ParameterGain import \
    ParamsGain
import traceback
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.storage.storage_tool import StorageTool


class IPkgDistribute(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id):
        super(IPkgDistribute, self).__init__(project_id, pod_id)
        self.db = BaseOps()
        self.project_id = project_id
        self.pod_id = pod_id
        param_getter = ParamsGain(project_id, pod_id, self.db)
        self.fs_args = dict()
        storage_tool = StorageTool(self.project_id, self.pod_id, self.db)
        fsm_args = storage_tool.get_storage_float_ip(az_mode="manager", reuse_mode="new", dc="standby")
        self.fs_args["float_ip"] = fsm_args[0].get("float_ip")
        self.fs_args["dm_update_pwd"] = fsm_args[0].get("portal_pwd")
        pkg_dir, pkg_name = param_getter.get_hot_patch_path()
        self.fs_args["package_path"] = os.path.join(pkg_dir, pkg_name)
        self.fs_args["package_name"] = pkg_name

    def execute(self, project_id, pod_id):
        """
        Perform an upgrade task
        """
        logger.info('Start distribute package.')
        try:
            logger.info('try Start distribute package.')
            DistributePkg(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, FCUException(626090, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        pass  # nothing to do

    def rollback(self, project_id, pod_id):
        pass  # nothing to do
