# -*- coding: utf-8 -*-
import traceback
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import FCDException
import utils.common.log as logger
from platforms.project.ProjectUtils import get_project_condition_boolean
from plugins.DistributedStorage.scripts.utils.iterm.ParameterGain import ParamsGain
from plugins.DistributedStorage.scripts.implement.TC_Config_ExternalKMS import ConfigExternalKMS


class ConfigExternalKMSIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        if get_project_condition_boolean(self.project_id, 'TenantStorFB80&ExpansionServiceStorage'):
            self.fs_args = ParamsGain(project_id, pod_id, self.db).get_business_separate_expand_fusionstorage_args()
        else:
            self.fs_args = ParamsGain(project_id, pod_id, self.db).get_business_separate_args()
        self.config_external_kms = ConfigExternalKMS(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建存储池，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.config_external_kms.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.config_external_kms.cleanup()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            ret = self.config_external_kms.cleanup()
            if ret.status_code != 200:
                return ret
            ret = self.config_external_kms.procedure()
            return ret
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, FCDException(626360, str(e)))

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
