/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv = null;
    private int version;
    private int rounds;
    private int wordSize;

    public RC5ParameterSpec(int n, int n2, int n3) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, 0);
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray, int n4) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        if (byArray == null) {
            throw new IllegalArgumentException("IV missing");
        }
        if (n4 < 0) {
            throw new ArrayIndexOutOfBoundsException("offset is negative");
        }
        int n5 = n3 / 8 * 2;
        if (byArray.length - n4 < n5) {
            throw new IllegalArgumentException("IV too short");
        }
        this.iv = new byte[n5];
        System.arraycopy(byArray, n4, this.iv, 0, n5);
    }

    public int getVersion() {
        return this.version;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public byte[] getIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)object;
        return this.version == rC5ParameterSpec.version && this.rounds == rC5ParameterSpec.rounds && this.wordSize == rC5ParameterSpec.wordSize && Arrays.equals(this.iv, rC5ParameterSpec.iv);
    }

    public int hashCode() {
        int n = 0;
        if (this.iv != null) {
            for (int i = 1; i < this.iv.length; ++i) {
                n += this.iv[i] * i;
            }
        }
        return n += this.version + this.rounds + this.wordSize;
    }
}

