/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dm;

import com.huawei.dm.Http11ProtocolWithKeystore;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class CertReplaceUtilForWindows {
    private static final int NUMBER_1024 = 1024;
    private static final int MAX_SIZE = 0x100000;
    private static PrintStream out = System.out;
    private static String CATALINA_HOME = System.getProperty("catalina.home");
    private static String TOMCAT_CONF = CATALINA_HOME + File.separator + "conf" + File.separator;
    private static Logger log = LogManager.getLogger(CertReplaceUtilForWindows.class);

    private CertReplaceUtilForWindows() {
    }

    public static void main(String[] stringArray) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        String string = System.getProperty("user.name");
        String string2 = console.readLine("Please enter file path:", new Object[0]);
        char[] cArray = console.readPassword("Please enter the keyPass:", new Object[0]);
        char[] cArray2 = console.readPassword("Please enter the confirmKeyPass:", new Object[0]);
        if (cArray == null || cArray.length == 0) {
            out.println("Secret key is null");
            return;
        }
        if (cArray2 == null || cArray2.length == 0) {
            out.println("Confirm secret key is null");
            return;
        }
        String string3 = new String(cArray);
        String string4 = new String(cArray2);
        if (!CertReplaceUtilForWindows.checkKeypass(string3, string4)) {
            return;
        }
        if (!CertReplaceUtilForWindows.checkPath(string2, string, string3)) {
            return;
        }
        int n = string2.lastIndexOf(File.separator);
        String string5 = string2.substring(n + 1);
        if (!CertReplaceUtilForWindows.copyFile(string2, TOMCAT_CONF + string5, string, string5)) {
            return;
        }
        CertReplaceUtilForWindows.modifyXML(string5, string3, string);
        log.error(string + " succeeded in replacing keystore file(" + string5 + ").");
    }

    private static boolean checkKeypass(String string, String string2) {
        if (!string.equals(string2)) {
            out.println("Secret keys do not match.");
            return false;
        }
        return true;
    }

    private static boolean checkPath(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            out.println("The certificate file is null.");
            return false;
        }
        if (!string.contains(".keystore")) {
            out.println("The certificate file is invalid.");
            return false;
        }
        File file = new File(string);
        if (file.isDirectory() || !file.exists()) {
            out.println("Specify file is not exist.");
            return false;
        }
        if (file.length() > 0x100000L) {
            log.error(string2 + " failed to replace keystore file(" + file.getName() + ").");
            out.println("The certificate file is too big.");
            return false;
        }
        if (!CertReplaceUtilForWindows.validateKeyStorePasword(file, string3)) {
            log.error(string2 + " failed to replace keystore file(" + file.getName() + ").");
            out.println("The certificate file is invalid.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateKeyStorePasword(File file, String string) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            fileInputStream = new FileInputStream(file);
            keyStore.load(fileInputStream, string.toCharArray());
            bl = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error("The certificate file(" + file.getName() + ") is invalid.");
        }
        catch (CertificateException certificateException) {
            log.error("The certificate file(" + file.getName() + ") is invalid.");
        }
        catch (IOException iOException) {
            log.error("The certificate file(" + file.getName() + ") is invalid.");
        }
        catch (KeyStoreException keyStoreException) {
            log.error("The certificate file(" + file.getName() + ") is invalid.");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    log.error("IO Close Error.");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(String string, String string2, String string3, String string4) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            try {
                int n;
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                log.error(string3 + " failed to replace keystore file(" + string4 + ").");
                out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + iOException.getLocalizedMessage());
                boolean bl = false;
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (Exception exception) {
                    log.error(string3 + " failed to replace keystore file(" + string4 + ").");
                    out.println("An internal error occurs.Suggestion: Contact Huawei technical support. error message:" + exception.getLocalizedMessage());
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    log.error(string3 + " failed to replace keystore file(" + string4 + ").");
                    out.println("An internal error occurs.Suggestion: Contact Huawei technical support. error message:" + exception.getLocalizedMessage());
                }
                return bl;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(string3 + " failed to replace keystore file(" + string4 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message: the file is invalid.");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (Exception exception) {
                log.error(string3 + " failed to replace keystore file(" + string4 + ").");
                out.println("An internal error occurs.Suggestion: Contact Huawei technical support. error message:" + exception.getLocalizedMessage());
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                log.error(string3 + " failed to replace keystore file(" + string4 + ").");
                out.println("An internal error occurs.Suggestion: Contact Huawei technical support. error message:" + exception.getLocalizedMessage());
            }
        }
        return true;
    }

    private static boolean modifyXML(String string, String string2, String string3) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error("Prevent xml injection error\uff1a " + string);
            out.println("Prevent xml injection error:" + parserConfigurationException.getLocalizedMessage());
            return false;
        }
        Element element = null;
        Element element2 = null;
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(TOMCAT_CONF + "server.xml"));
            element2 = document.getDocumentElement();
            element = (Element)CertReplaceUtilForWindows.selectSingleNode("/Server/Service/Connector", element2, string3, string);
            if (null == element) {
                log.error(string3 + " failed to replace keystore file(" + string + ").");
                out.println("Select the node return null.");
                return false;
            }
            element.setAttribute("keystorePass", Http11ProtocolWithKeystore.encript(string2));
            element.setAttribute("keystoreFile", "conf/" + string);
            return CertReplaceUtilForWindows.saveXml(TOMCAT_CONF + "server.xml", document, string3, string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error(string3 + " failed to replace keystore file(" + string + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + parserConfigurationException.getLocalizedMessage());
            return false;
        }
        catch (SAXException sAXException) {
            log.error(string3 + " failed to replace keystore file(" + string + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + sAXException.getLocalizedMessage());
            return false;
        }
        catch (IOException iOException) {
            log.error(string3 + " failed to replace keystore file(" + string + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + iOException.getLocalizedMessage());
            return false;
        }
    }

    private static Node selectSingleNode(String string, Object object, String string2, String string3) {
        Node node = null;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            node = (Node)xPath.evaluate(string, object, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            log.error(string2 + " failed to replace keystore file(" + string3 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + xPathExpressionException.getLocalizedMessage());
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveXml(String string, Document document, String string2, String string3) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        FileOutputStream fileOutputStream = null;
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource();
            document.setXmlStandalone(true);
            dOMSource.setNode(document);
            StreamResult streamResult = new StreamResult();
            fileOutputStream = new FileOutputStream(string);
            streamResult.setOutputStream(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
            boolean bl = true;
            return bl;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            log.error(string2 + " failed to replace keystore file(" + string3 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + transformerConfigurationException.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (TransformerException transformerException) {
            log.error(string2 + " failed to replace keystore file(" + string3 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + transformerException.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(string2 + " failed to replace keystore file(" + string3 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message: the file is invalid.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    log.error(string2 + " failed to replace keystore file(" + string3 + ").");
                    out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + iOException.getLocalizedMessage());
                }
            }
        }
    }
}

