/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.chrono.IsoChronology;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.LocalGregorianCalendar;

public final class JapaneseChronology
extends AbstractChronology
implements Serializable {
    static final LocalGregorianCalendar JCAL = (LocalGregorianCalendar)CalendarSystem.forName("japanese");
    static final Locale LOCALE = Locale.forLanguageTag("ja-JP-u-ca-japanese");
    public static final JapaneseChronology INSTANCE = new JapaneseChronology();
    private static final long serialVersionUID = 459996390165777884L;

    private JapaneseChronology() {
    }

    @Override
    public String getId() {
        return "Japanese";
    }

    @Override
    public String getCalendarType() {
        return "japanese";
    }

    @Override
    public JapaneseDate date(Era era, int n, int n2, int n3) {
        if (!(era instanceof JapaneseEra)) {
            throw new ClassCastException("Era must be JapaneseEra");
        }
        return JapaneseDate.of((JapaneseEra)era, n, n2, n3);
    }

    @Override
    public JapaneseDate date(int n, int n2, int n3) {
        return new JapaneseDate(LocalDate.of(n, n2, n3));
    }

    @Override
    public JapaneseDate dateYearDay(Era era, int n, int n2) {
        return JapaneseDate.ofYearDay((JapaneseEra)era, n, n2);
    }

    @Override
    public JapaneseDate dateYearDay(int n, int n2) {
        return new JapaneseDate(LocalDate.ofYearDay(n, n2));
    }

    @Override
    public JapaneseDate dateEpochDay(long l) {
        return new JapaneseDate(LocalDate.ofEpochDay(l));
    }

    @Override
    public JapaneseDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public JapaneseDate dateNow(ZoneId zoneId) {
        return this.dateNow(Clock.system(zoneId));
    }

    @Override
    public JapaneseDate dateNow(Clock clock) {
        return this.date(LocalDate.now(clock));
    }

    @Override
    public JapaneseDate date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof JapaneseDate) {
            return (JapaneseDate)temporalAccessor;
        }
        return new JapaneseDate(LocalDate.from(temporalAccessor));
    }

    public ChronoLocalDateTime<JapaneseDate> localDateTime(TemporalAccessor temporalAccessor) {
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<JapaneseDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<JapaneseDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        return super.zonedDateTime(instant, zoneId);
    }

    @Override
    public boolean isLeapYear(long l) {
        return IsoChronology.INSTANCE.isLeapYear(l);
    }

    @Override
    public int prolepticYear(Era era, int n) {
        if (!(era instanceof JapaneseEra)) {
            throw new ClassCastException("Era must be JapaneseEra");
        }
        JapaneseEra japaneseEra = (JapaneseEra)era;
        int n2 = japaneseEra.getPrivateEra().getSinceDate().getYear() + n - 1;
        if (n == 1) {
            return n2;
        }
        if (n2 >= -999999999 && n2 <= 999999999) {
            LocalGregorianCalendar.Date date = JCAL.newCalendarDate(null);
            date.setEra(japaneseEra.getPrivateEra()).setDate(n, 1, 1);
            if (JCAL.validate(date)) {
                return n2;
            }
        }
        throw new DateTimeException("Invalid yearOfEra value");
    }

    @Override
    public JapaneseEra eraOf(int n) {
        return JapaneseEra.of(n);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(JapaneseEra.values());
    }

    JapaneseEra getCurrentEra() {
        JapaneseEra[] japaneseEraArray = JapaneseEra.values();
        return japaneseEraArray[japaneseEraArray.length - 1];
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        switch (chronoField) {
            case ALIGNED_DAY_OF_WEEK_IN_MONTH: 
            case ALIGNED_DAY_OF_WEEK_IN_YEAR: 
            case ALIGNED_WEEK_OF_MONTH: 
            case ALIGNED_WEEK_OF_YEAR: {
                throw new UnsupportedTemporalTypeException("Unsupported field: " + chronoField);
            }
            case YEAR_OF_ERA: {
                Calendar calendar = Calendar.getInstance(LOCALE);
                int n = this.getCurrentEra().getPrivateEra().getSinceDate().getYear();
                return ValueRange.of(1L, calendar.getGreatestMinimum(1), calendar.getLeastMaximum(1) + 1, 999999999 - n);
            }
            case DAY_OF_YEAR: {
                Calendar calendar = Calendar.getInstance(LOCALE);
                int n = 6;
                return ValueRange.of(calendar.getMinimum(n), calendar.getGreatestMinimum(n), calendar.getLeastMaximum(n), calendar.getMaximum(n));
            }
            case YEAR: {
                return ValueRange.of(JapaneseDate.MEIJI_6_ISODATE.getYear(), 999999999L);
            }
            case ERA: {
                return ValueRange.of(JapaneseEra.MEIJI.getValue(), this.getCurrentEra().getValue());
            }
        }
        return chronoField.range();
    }

    @Override
    public JapaneseDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        return (JapaneseDate)super.resolveDate(map, resolverStyle);
    }

    @Override
    ChronoLocalDate resolveYearOfEra(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        Long l = map.get(ChronoField.ERA);
        JapaneseEra japaneseEra = null;
        if (l != null) {
            japaneseEra = this.eraOf(this.range(ChronoField.ERA).checkValidIntValue(l, ChronoField.ERA));
        }
        Long l2 = map.get(ChronoField.YEAR_OF_ERA);
        int n = 0;
        if (l2 != null) {
            n = this.range(ChronoField.YEAR_OF_ERA).checkValidIntValue(l2, ChronoField.YEAR_OF_ERA);
        }
        if (japaneseEra == null && l2 != null && !map.containsKey(ChronoField.YEAR) && resolverStyle != ResolverStyle.STRICT) {
            japaneseEra = JapaneseEra.values()[JapaneseEra.values().length - 1];
        }
        if (l2 != null && japaneseEra != null) {
            if (map.containsKey(ChronoField.MONTH_OF_YEAR) && map.containsKey(ChronoField.DAY_OF_MONTH)) {
                return this.resolveYMD(japaneseEra, n, map, resolverStyle);
            }
            if (map.containsKey(ChronoField.DAY_OF_YEAR)) {
                return this.resolveYD(japaneseEra, n, map, resolverStyle);
            }
        }
        return null;
    }

    private int prolepticYearLenient(JapaneseEra japaneseEra, int n) {
        return japaneseEra.getPrivateEra().getSinceDate().getYear() + n - 1;
    }

    private ChronoLocalDate resolveYMD(JapaneseEra japaneseEra, int n, Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        map.remove(ChronoField.ERA);
        map.remove(ChronoField.YEAR_OF_ERA);
        if (resolverStyle == ResolverStyle.LENIENT) {
            int n2 = this.prolepticYearLenient(japaneseEra, n);
            long l = Math.subtractExact(map.remove(ChronoField.MONTH_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.DAY_OF_MONTH), 1L);
            return this.date(n2, 1, 1).plus(l, ChronoUnit.MONTHS).plus(l2, ChronoUnit.DAYS);
        }
        int n3 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
        int n4 = this.range(ChronoField.DAY_OF_MONTH).checkValidIntValue(map.remove(ChronoField.DAY_OF_MONTH), ChronoField.DAY_OF_MONTH);
        if (resolverStyle == ResolverStyle.SMART) {
            JapaneseDate japaneseDate;
            if (n < 1) {
                throw new DateTimeException("Invalid YearOfEra: " + n);
            }
            int n5 = this.prolepticYearLenient(japaneseEra, n);
            try {
                japaneseDate = this.date(n5, n3, n4);
            }
            catch (DateTimeException dateTimeException) {
                japaneseDate = this.date(n5, n3, 1).with(TemporalAdjusters.lastDayOfMonth());
            }
            if (japaneseDate.getEra() != japaneseEra && japaneseDate.get(ChronoField.YEAR_OF_ERA) > 1 && n > 1) {
                throw new DateTimeException("Invalid YearOfEra for Era: " + japaneseEra + " " + n);
            }
            return japaneseDate;
        }
        return this.date(japaneseEra, n, n3, n4);
    }

    private ChronoLocalDate resolveYD(JapaneseEra japaneseEra, int n, Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        map.remove(ChronoField.ERA);
        map.remove(ChronoField.YEAR_OF_ERA);
        if (resolverStyle == ResolverStyle.LENIENT) {
            int n2 = this.prolepticYearLenient(japaneseEra, n);
            long l = Math.subtractExact(map.remove(ChronoField.DAY_OF_YEAR), 1L);
            return this.dateYearDay(n2, 1).plus(l, ChronoUnit.DAYS);
        }
        int n3 = this.range(ChronoField.DAY_OF_YEAR).checkValidIntValue(map.remove(ChronoField.DAY_OF_YEAR), ChronoField.DAY_OF_YEAR);
        return this.dateYearDay(japaneseEra, n, n3);
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }
}

