#!/bin/bash
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
source ${CURRENT_DIR}/common.sh
readonly COMPONENT="Deploymanager"
readonly HA_PROPERTIES="/home/HAInfoFromInstallTool.properties"

function is_valid_ipv6()
{
    if [ x"$1" == x"::" -o x"$1" == x"0:0:0:0:0:0:0:0" ]; then
        return 1
    fi
    ipcalc -cs6 "$1" && return 0 || return 1
}

function main
{
    HA_MODE=$(cat ${HA_PROPERTIES} | grep ha_mode | awk -F "=" '{print $2}')
	if [ $HA_MODE == "single" ]; then
		log "single, no need to check floatIP"
	    exit 0
	else
		PING_CMD="ping"
		float_ip=$(grep -n "float_ip_for_ha=" ${HA_PROPERTIES} | awk -F "=" '{print $2}')
		is_valid_ipv6 "${float_ip}"
		if [ $? -eq 0 ];then
			log "${float_ip} is ipv6"
			PING_CMD="ping6"
		fi
		${PING_CMD} -c 3 ${float_ip} >>${log_file} 2>&1
		if [ $? -eq 0 ]; then
			arp >>${log_file} 2>&1
			${PING_CMD} -c 3 ${float_ip} >>${log_file} 2>&1
			if [ $? -eq 0 ]; then
			  log "${float_ip} has been used somewhere, please check whether if the floatIP is available!"
              logger ${COMPONENT}/48322115
			  exit 1
			fi
		fi
    PING_CMD="ping"
		secondary_float_ip=$(grep -n "secondary_external_service_float_ip=" ${HA_PROPERTIES} | awk -F "=" '{print $2}')
		is_valid_ipv6 "${secondary_float_ip}"
		if [ $? -eq 0 ];then
			log "${secondary_float_ip} is ipv6"
			PING_CMD="ping6"
		fi
		${PING_CMD} -c 3 ${secondary_float_ip} >>${log_file} 2>&1
		if [ $? -eq 0 ]; then
			arp >>${log_file} 2>&1
			${PING_CMD} -c 3 ${secondary_float_ip} >>${log_file} 2>&1
			if [ $? -eq 0 ]; then
			  log "${secondary_float_ip} has been used somewhere, please check whether if the secondary float ip is available!"
              logger ${COMPONENT}/48322118
			  exit 1
			fi
		fi
	fi
	exit 0
}
initLog
main
