# -*- coding: utf-8 -*-
"""
Storage参数校验
"""
import utils.common.log as logger
from platforms.param.param_check_handler import HandleParamCheck
from platforms.param.param_service import ParamService
from platforms.project.projectservice import ProjectService
from utils.business.vm_util import can_vm_pinged_to
from utils.common.exception import FCUException
from plugins.DistributedStorage.common.UpgradeOperate import UpgradeOperate
from utils.business.project_util import ProjectApi
import traceback


def params_check(project_id):
    check_result = HandleParamCheck()
    check_list = []
    try:
        """参数检验"""
        logger.info('Start parameter verification task.')
        service_name = "DistributedStorage"
        suit_info = ProjectApi().get_storage80_info(project_id)
        check_data = ParamService().get_need_check_cloud_params(project_id,
                                                                service_name)
        project_info = ProjectService().get_project_info(project_id)
        print(project_info)
        for suit_id, float_ip in suit_info.items():
            logger.info("check {} begin".format(suit_id))

            rest_check_list = ['FSM_{}_float_ip', 'FSM_{}_rest_user',
                               'FSM_{}_rest_pwd']
            check_list = [str(i).format(suit_id) for i in rest_check_list]

            _check_rest_connectivity(check_list, check_data, check_result,
                                     suit_id, float_ip)

    except FCUException as err:
        exc = traceback.format_exc()
        logger.error('param check failed.%s' % (str(exc)))
        check_result.set_check_result(param_keys=check_list,
                                      status=500,
                                      error_msg=err)
    except Exception as ex:
        logger.error(ex)
        exc = traceback.format_exc()
        logger.error('param check failed.%s' % (str(exc)))
        check_result.set_check_result(param_keys=check_list,
                                      status=500,
                                      error_msg=FCUException(620050, str(ex)))
    return check_result


def _check_rest_connectivity(check_list, check_data, check_result, suit_id, float_ip):
    data_dict = get_check_item(check_list, check_data, check_result)
    if len(data_dict) == 0:
        return
    check_float_ip = data_dict.get(check_list[0])
    if check_float_ip != float_ip:

        check_result.set_check_result(
            check_list, 500,
            FCUException(621012, suit_id, float_ip, check_float_ip))
    else:
        if not check_ping(check_list, check_result, data_dict):
            return
        if check_rest_connectivity(check_list, data_dict,
                                   check_result):
            check_result.set_check_result(
                param_keys=check_list, status=200)


def get_check_item(check_list, check_data, check_result):
    data_dict = {}
    error = []
    for key, val in check_data.items():
        if key in check_list and val:
            data_dict.update({key: val})
        elif key in check_list and not val:
            error.append(key)
    if error:
        logger.error("check key {} error".format(', '.join(error)))
        check_result.set_check_result(check_list,
                                      500,
                                      FCUException(620053, ', '.join(error)))
        return {}
    return data_dict


def check_ping(check_list, check_result, data_dict):
    check_pass_flag = True
    ip_addr = data_dict.get(check_list[0])
    result = can_vm_pinged_to(ip_addr)
    if not result:
        logger.error("IP({}) is unreachable.".format(ip_addr))
        logger.error("check ping ip {ip_list} error, "
                     "error: {result}".format(ip_list=ip_addr,
                                              result=result))
        check_result.set_check_result(check_list,
                                      500,
                                      FCUException(620054, ip_addr))
        check_pass_flag = False
    return check_pass_flag


def check_rest_connectivity(check_list, data_dict, check_result):
    """
    :param data_dict:
    :param check_result:
    :param check_list:
    :return:
    """
    try:
        check_pass_flag = True
        # 组合请求数据
        logger.info('Start collecting request data.')
        fs_args = dict()
        fs_args['float_ip'] = data_dict.get(check_list[0])
        fs_args['user_name'] = data_dict.get(check_list[1])
        fs_args['password'] = data_dict.get(check_list[2])
        fs_args['port'] = "8088"
        operator = UpgradeOperate(fs_args)
        status_code, error_code, error_des = operator.login(
            fs_args['user_name'], fs_args['password'])
        if status_code != 200 or error_code != 0:
            err_msg = "Failed to login, Detail:[status:%s,code:%s]%s" \
                      % (status_code, error_code, error_des)
            logger.error(err_msg)
            raise Exception(err_msg)

        ret_result, ret_data = operator.logout()
        if ret_result["code"] != 0:
            err_msg = "Failed to logout, Detail:[{0}, {1}]".format(
                ret_result, ret_data)
            logger.error(err_msg)
            raise Exception(err_msg)

    except FCUException as err:
        logger.error(err)
        logger.error(traceback.format_exc())
        check_result.set_check_result(param_keys=check_list,
                                      status=500,
                                      error_msg=err)
        check_pass_flag = False
    except Exception as ex:
        logger.error(ex)
        logger.error(traceback.format_exc())
        check_result.set_check_result(param_keys=check_list,
                                      status=500,
                                      error_msg=FCUException(620050, str(ex)))
        check_pass_flag = False
    finally:
        logger.info('check_rest_connectivity end.')

    return check_pass_flag
