# -*- coding: utf-8 -*-
"""
Storage 升级任务
"""
import os

import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.basic.scripts.impl.TC_Clouda_Self_Upgrade import CloudaSelfUpgrade
from plugins.DistributedStorage.common.ParameterGain import ParamsGain


class SelfUpgrade(StepBaseInterface):
    """
    Packege Upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(SelfUpgrade, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)
        pkg_name, pkg_dir = ParamsGain(project_id, pod_id, regionid_list).get_storage_package()
        self.fs_args["package_name"] = pkg_name
        self.fs_args["package_path"] = os.path.join(pkg_dir, pkg_name)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start deploy manager self upgrade task.')
        try:
            CloudaSelfUpgrade(project_id, pod_id, self.fs_args).run()
        except FCUException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCUException(621003, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
