# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.Deploy.scripts.BusinessConverge.implement.TC_Config_KVMResourcePool import \
    ConfigKVMResourcePool
from utils.common.message import Message
from plugins.DistributedStorage.utils.iterm.ParameterGain import ParamsGain
from utils.DBAdapter.DBConnector import BaseOps


class ConfigKVMResourcePoolIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_business_converge_args()

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装&配置
        :return: Message对象
        """
        return ConfigKVMResourcePool(project_id, pod_id, self.fs_args).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def check(self, project_id, pod_id):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return:
        """
        return ConfigKVMResourcePool(project_id, pod_id, self.fs_args).run()
