# -*- coding: utf-8 -*-
"""
Storage 升级前检查
"""
import utils.common.log as logger
from plugins.DistributedStorage.Upgrade.scripts.impl.TC_Pre_Upgrade_Check import \
    PreUpgradeCheck
from plugins.DistributedStorage.utils.common.upgrade_base import \
    UpgradeBaseInterface


class IPreCheck(UpgradeBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id):
        super(IPreCheck, self).__init__(project_id, pod_id,
                                        az_mode="manager", reuse_mode="new", dc="standby")
        self.error_code = 626302

    def run(self, project_id, pod_id):
        """
        Perform an upgrade task
        """
        logger.info('Start pre upgrade check.')
        PreUpgradeCheck(project_id, pod_id, self.fs_args).procedure()

    def retry_run(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('Start pre upgrade check.')
        PreUpgradeCheck(project_id, pod_id, self.fs_args).procedure()