# -*- coding: utf-8 -*-
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.business.project_condition_utils import get_project_condition_boolean
from plugins.DistributedStorage.utils.iterm.ParameterGain import ParamsGain
from plugins.DistributedStorage.Deploy.scripts.BusinessSeparate.implement.TC_Config_ResourcePool import ConfigResourcePool


class ConfigResourcePoolIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.params = ParamsGain(project_id, pod_id, self.db)
        if get_project_condition_boolean(self.project_id, 'TenantStorNewPool|TenantStorNewNode'):
            fs_args = self.params.get_business_separate_expand_fusionstorage_args_while_new_pool_or_new_node()
        else:
            fs_args = self.params.get_business_separate_args()
        self.fs_args = fs_args
        self.config_resource_pool = ConfigResourcePool(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装&配置
        :return: Message对象
        """
        return self.config_resource_pool.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return self.config_resource_pool.rollback_procedure()

    def check(self, project_id, pod_id):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return:
        """
        return ConfigResourcePool(project_id, pod_id, self.fs_args).run()
