#!/bin/bash

path=`pwd`
tmp_disk=$path/tmp_disk
tool=$path/smio_llt_ioctl_bin
cfg_file=$path/smio_llt_env_conf.cfg

if [ $# -ne 3 ]
    then
        echo "usage:"
        echo "      sh modify_disk.sh cache_num cache_type main_storage_type"
        echo "      for example: sh modify_disk.sh 2 2 5"
        echo "para meaning:"
        echo "      cache_type:PCIE_SSD=1，SAS_SSD=2，SATA_SSD=3，SAS_HDD=4, SATA_HDD=5"
        echo "      mainstorage_type:PCIE_SSD=1，SAS_SSD=2，SATA_SSD=3，SAS_HDD=4, SATA_HDD=5"
    exit 1
fi

#check excute folder
if [ ! -f $tool ]
then
   echo "please switch to the folder where the script stored" 
   exit 1
fi

#check right of tool
if [ ! -x $tool ]
then
   chmod +x $tool
fi

cache_num=$1
cache_type="$2"
mainStor_type="$3"


#get disk info from smio:
cat /proc/smio_host | grep -v Name | awk -F\| '{print $3,$7}'| sort  > $tmp_disk

#gen disk cfg
i=0

#if cfg exist,clear it
if [ -f $cfg_file ]
then
   echo > $cfg_file
fi

#start gen
while read Line;
do 
   name=`echo $Line | awk '{print $1}'`
   esn=`echo $Line | awk '{print $2}'`
   echo "media_index_$i=$i" >> $cfg_file
   echo "esn_$i=$esn" >> $cfg_file
   echo "slot_$i=$i" >> $cfg_file;
   echo "dev_name_$i=$name" >> $cfg_file;
   if [ "$i" -eq "$cache_num" ]
   then 
       echo "type_$i=$cache_type" >> $cfg_file; 
   else
       echo "type_$i=$mainStor_type" >> $cfg_file;
   fi
   echo  >> $cfg_file
   i=`expr $i + 1`
done < $tmp_disk

#write cfg to disk
$tool write_media_info $cfg_file > /dev/null 

#reload smio
cd /opt/dsware/osd/ko/`uname -r`/smio
./smio_stop >/dev/null
./smio_start>/dev/null

#finished
sleep 3
cat /proc/smio_host



