# -*- coding: utf-8 -*-
import traceback

import utils.common.log as logger
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import FCDException
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.scripts.implement.tc_storage_node_config_raid_tool import ConfigureRaidModeImpl


class ConfigRaidToolInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(ConfigRaidToolInterface, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = {"bmc_info_list": self.db.get_install_os_list_info(self.pod_id, "rep")}

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            ConfigureRaidModeImpl(self.fs_args).procedure()
        except FCDException as e:
            logger.error("Error:{}, details:{}".format(e, traceback.format_exc()))
            return Message(500, e)
        except Exception as e:
            return Message(500, e)
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
