# -*- coding: utf-8 -*-
"""
Storage 升级前检查
"""
import utils.common.log as logger
from utils.common.message import Message
from utils.common.fic_base import StepBaseInterface
from utils.common.exception import FCUException
from plugins.DistributedStorage.common.ParameterGain import ParamsGain
from plugins.DistributedStorage.basic.scripts.impl.TC_Post_Upgrade_Check import PostUpgradeCheck


class PostCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PostCheck, self).__init__(project_id, pod_id, regionid_list)
        params_gain = ParamsGain(project_id, pod_id, regionid_list)
        self.fs_args = params_gain.get_args(suit_id)
        self.fs_args["upgrade_type"] = "rollback"

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start post rollback check.')
        try:
            PostUpgradeCheck(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('Post rollback check failed')
            return Message(500, e)
        except Exception as e:
            logger.error('Post rollback check failed')
            return Message(500, FCUException(621002, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
