#!/bin/bash
set +x

readonly deploymanager_tool=/opt/fusionstorage/deploymanager/servicetool/script/servicetool.sh
readonly db_restore=/opt/fusionstorage/deploymanager/gaussdb/app/bin/gsql
readonly REPOMAN_CONF=/opt/fusionstorage/deploymanager/Tomcat/config.ini
readonly LOG_FILE="/var/log/deploy/backup/deploymanager_restore.log"
readonly CMDB_BACKUP_DB_FILENAME=deploymanager_cmdb_back_up_file.sql
readonly CMDB_DB_NAME=cmdb
readonly DP_USER=fdadmin
readonly DP_GROUP=ops
readonly DMDBADMIN=dmdbadmin
readonly ADMIN=admin
SCRIPTNAME=$(basename $0)
PASS_CONF_PATH=/opt/fusionstorage/deploymanager/servicetool/bin/pass_conf.ini
DECRYPT_BASH=/opt/fusionstorage/deploymanager/servicetool/bin/kmc_passwd.sh
jdkpath='/opt/fusionstorage/deploymanager/jre/bin/java -jar'
jarpath='/opt/fusionstorage/deploymanager/kmc/lib/WccCryptUtil-1.0.0.jar'

step=$1
if [ -z "${step}" ];then
    exit 1
fi
restoreDbDir=/home/dmdbadmin/deploymanager/${step}

function log()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[$(date +'%F %T')][${param1}][${param2}]${param3}"
    if [ ! -f "${LOG_FILE}" ]; then
        log_path=`dirname "${LOG_FILE}"`
        mkdir -p "${log_path}"
        [ ! -L "${log_path}" ] && chmod 750 "${log_path}"
        touch "${LOG_FILE}"
        [ ! -L "${LOG_FILE}" ] && chmod 640 "${LOG_FILE}"
    fi
    [ ! -L "${LOG_FILE}" ] && echo "[$(date +'%F %T')][${param1}][${param2}]${param3}" >> "${LOG_FILE}" 2>/dev/null
}

function prepare()
{
    if [ ! -f ${REPOMAN_CONF} ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] database conf file no exist!"
        return 1
    fi

    if [ ! -f ${restoreDbDir}/${CMDB_BACKUP_DB_FILENAME} ] ; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] restore ${restoreDbDir}/${CMDB_BACKUP_DB_FILENAME} does not exist."
        return 1
    fi
    return 0
}

function get_pwd()
{
    local encrypt_init_pwd=$(su - fdadmin -s /bin/bash -c "grep 'DATABASE_INIT_PASSWORD_WCC=' ${REPOMAN_CONF}" | cut -d'=' -f2-)
    if [ -f "${DECRYPT_BASH}" ]; then
        DATABASEINITPW_DE=$(/bin/bash ${DECRYPT_BASH} decrypt ${encrypt_init_pwd})
        if [ -f "${PASS_CONF_PATH}" ]; then
            source ${PASS_CONF_PATH}
            DATABASEINITPW_DE=$(echo ${DATABASEINITPW_DE} | rev | sed "y/$des/$ens/")
        fi
    else
        DECRYPT_BASH="/opt/fusionstorage/deploymanager/servicetool/bin/str_util.sh"
        DATABASEINITPW_DE=$(su - fdadmin -s /bin/bash -c "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/fusionstorage/deploymanager/kmc/bin;$jdkpath $jarpath d" <<EOF
${encrypt_init_pwd}
EOF
)
        source "/opt/fusionstorage/deploymanager/servicetool/pub/pub_str.ini"
        DATABASEINITPW_DE=$(echo ${DATABASEINITPW_DE} | rev | sed "y/$str_2/$str_1/")
    fi
    return 0
}

##############################################################
## @Usage restoreDbData
## @param $1    参数的键
## @Return      返回0
## @Description 备份DEPLOYMANAGER数据库文件中的数据信息
##############################################################
function restoreCmdbDb()
{
    #执行数据库恢复操作
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Start to restore deploymanager databse data."
    \cp -f -P --remove-destination ${restoreDbDir}/${CMDB_BACKUP_DB_FILENAME} /opt/fusionstorage/deploymanager
    if [ $? -ne 0 ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] cp ${CMDB_BACKUP_DB_FILENAME} database data failed."
        return 1
    fi
    chown -h ${DMDBADMIN}:${DP_GROUP} /opt/fusionstorage/deploymanager/${CMDB_BACKUP_DB_FILENAME}
    if [ $? -ne 0 ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] chown -h ${CMDB_BACKUP_DB_FILENAME} database data failed."
        return 1
    fi
    su - $DMDBADMIN -s /bin/bash -c "${db_restore} -p 7018 -U dmdbadmin -d ${CMDB_DB_NAME} -f /opt/fusionstorage/deploymanager/${CMDB_BACKUP_DB_FILENAME}" >>${LOG_FILE} 2>&1 <<EOF
${DATABASEINITPW_DE}
EOF
    if [ $? -ne 0 ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] restore ${CMDB_DB_NAME} database data failed."
        su - $DMDBADMIN -s /bin/bash -c "${db_restore} -h 127.0.0.1 -p 7018 -U dmdbadmin -d ${CMDB_DB_NAME} -f /opt/fusionstorage/deploymanager/${CMDB_BACKUP_DB_FILENAME}" >>${LOG_FILE} 2>&1 <<EOF
${DATABASEINITPW_DE}
EOF
        if [ $? -ne 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] restore ${CMDB_DB_NAME} database data failed."
            rm -f /opt/fusionstorage/deploymanager/${CMDB_BACKUP_DB_FILENAME}
            return 1
        fi
    fi
    rm -f /opt/fusionstorage/deploymanager/${CMDB_BACKUP_DB_FILENAME}
    return 0
}

##############################################################
## @Usage grantPrivilege
## @param    参数的键
## @Return      返回0
## @Description 恢复DEPLOYMANAGER配置文件中的数据信息
##############################################################
function grantPrivilege()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] begin grantPrivilege for ${ADMIN}."
    su - $DMDBADMIN -s /bin/bash -c "${db_restore} -p 7018 -d postgres -c 'grant all privileges to $ADMIN;'" >>${LOG_FILE} 2>&1 <<EOF
${DATABASEINITPW_DE}
EOF
    if [ $? -ne 0 ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] grantPrivilege for ${ADMIN} failed."
        su - dmdbadmin -s /bin/bash -c "${db_restore} -h 127.0.0.1 -p 7018 -d postgres -c 'grant all privileges to $ADMIN;'" >>${LOG_FILE} 2>&1 <<EOF
${DATABASEINITPW_DE}
EOF
        if [ $? -ne 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] grantPrivilege for ${ADMIN} failed."
            return 1
        fi
    fi
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] grantPrivilege for ${ADMIN} success."
    return 0
}

function stop_deploymanager()
{
    if [ ! -f ${deploymanager_tool} ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] ${deploymanager_tool} is empty."
        return 1
    fi
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] stop deploymanger."
    local i=1
    while [ $i -le 3 ]
    do
        su - ${DP_USER} -s /bin/bash -c "bash ${deploymanager_tool} stop" >/dev/null 2>&1
        if [ $? -eq 0 ]; then
            break
        else
            sleep 5
            let i++
        fi
    done
    su - ${DP_USER} -s /bin/bash -c "bash ${deploymanager_tool} status" >/dev/null 2>&1
    if [ $? -eq 1 ];then
        return 0
    else
        return 1
    fi
}

function start_deploymanager()
{
    if [ ! -f ${deploymanager_tool} ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] ${deploymanager_tool} is empty."
        return 1
    fi
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] start deploymanger"
    local i=1
    while [ $i -le 3 ]
    do
        su - ${DP_USER} -s /bin/bash -c "bash ${deploymanager_tool} start" >/dev/null 2>&1
        if [ $? -eq 0 ]; then
            break
        else
            sleep 5
            let i++
        fi
    done
    su - ${DP_USER} -s /bin/bash -c "bash ${deploymanager_tool} status" >/dev/null 2>&1
    if [ $? -eq 0 ];then
        return 0
    else
        return 1
    fi
}

function main()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Start restore data.."
    prepare
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] prepare failed!" && return 1
    get_pwd
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] get pwd failed!" && return 1
    stop_deploymanager
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] stop deploymanager failed!" && return 1
    grantPrivilege
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] grant privilege failed!" && return 1
    restoreCmdbDb
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] restore CmdbDb failed!" && return 1
    start_deploymanager
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] start deploymanager failed!" && return 1
    return 0
}

main
if [ $? -ne 0 ];then
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] restore data failed!"
    exit 1
fi
log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] restore data success!"
exit 0
