# -*-coding:utf-8-*-
import json
import re
import os
import stat
from utils.common import log as logger
from utils.constant.path_constant import ProjectPluginsPath
from plugins.ResourceCheck.common.libs.BMCCmd import BMCCmdExc


class PreCheckOperate(object):
    JSON_PATH = r'{}/DistributedStorage/Deploy/scripts/PreCheck/common/distributed_storage_node_cpu_arch.json' \
        .format(ProjectPluginsPath.project_plugins_path())

    @classmethod
    def update_json_file(cls, json_path, stream):
        """不存在创建json文件，存在则清空内容后写入stream"""
        flags = os.O_WRONLY | os.O_CREAT | os.O_TRUNC
        modes = stat.S_IWUSR | stat.S_IRUSR | stat.S_IXUSR | stat.S_IRGRP | stat.S_IXGRP
        with os.fdopen(os.open(json_path, flags, modes), 'w') as f:
            json.dump(stream, f, indent=2, ensure_ascii=False)

    @classmethod
    def get_system_arch(cls, bmc_ip_list):
        """
        minios中获取分离部署存储节点CPU架构存入json文件
        :return:
        """
        cmd = "uname -p"
        cmd_exe = BMCCmdExc()
        bmc_ip_list = list(set(bmc_ip_list))
        result_all = cmd_exe.run(bmc_ip_list, cmd)
        logger.info("Exec cmd: %s, result: %s" % (cmd, result_all))
        for bmc_ip in bmc_ip_list:
            result = result_all[bmc_ip]['stdout']
            ret_arch_list = re.findall('x86_64|aarch64', result)
            if len(ret_arch_list) == 1:
                ret_arch = ret_arch_list[0]
            else:
                err_msg = "Failed query cpu arch, cmd result:%s find:%s" % (result, ret_arch_list)
                logger.error(err_msg)
                raise Exception(err_msg)
            if ret_arch == 'x86_64':
                serv_cpu_arch = 'X86'
            elif ret_arch == 'aarch64':
                serv_cpu_arch = 'ARM'
            else:
                serv_cpu_arch = 'Unkown'
                err_msg = "Failed get processor type, cmd result:%s find:%s" % (result, serv_cpu_arch)
                logger.error(err_msg)
                raise Exception(err_msg)
            logger.info("Processor type:%s" % serv_cpu_arch)
            result_all[bmc_ip]['stdout'] = serv_cpu_arch
        cls.update_json_file(cls.JSON_PATH, result_all)
        return result_all

    @classmethod
    def get_1880_raid_node(cls, bmc_ip_list):
        cmd = "lspci |grep -v grep|grep RAID.*3758"
        cmd_exe = BMCCmdExc()
        bmc_ip_list = list(set(bmc_ip_list))
        result_all = cmd_exe.run(bmc_ip_list, cmd)
        logger.info("Exec cmd: %s, result: %s" % (cmd, result_all))
        for bmc_ip in bmc_ip_list:
            is_1880 = False
            result = result_all.get(bmc_ip).get('stdout')
            if re.search("RAID.*3758", result):
                is_1880 = True
            result_all.get(bmc_ip)['is_1880'] = is_1880
        return result_all
