# -*- coding: utf-8 -*-
import utils.common.log as logger
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.fic_base import TestCase
from utils.common.message import Message
from plugins.ResourceCheck.common.libs import network_libs

logger.init("FusionStorageBlockReplication")


class RepPreConfigImpl(TestCase):
    def __init__(self, project_id, pod_id):
        self.pod_id = pod_id
        self.project_id = project_id
        self.db = BaseOps()

    def procedure(self):
        """
        检查Rep pre Check
        """
        # 是否存在  两个pod场景  需确认
        bmc_info_lists = self.db.get_install_os_list_info(self.pod_id, "rep")
        pci_obj = network_libs.NicPciCls(bmc_info_lists)
        for bmc_info in bmc_info_lists:
            logger.info("bmc_ip:%s Nic slot map check" % bmc_info['bmc_ip'])
            manage_nic_list = bmc_info['management_plane'].replace(' ', '').split(',')
            storage_nic_list = bmc_info['storage_plane'].replace(' ', '').split(',')
            rep_nic_list = bmc_info['replication_plane'].replace(' ', '').split(',')
            nic_list = manage_nic_list + storage_nic_list + rep_nic_list
            for slot in nic_list:
                nic = pci_obj.get_nic_name_by_slot(bmc_info['bmc_ip'], slot, ignore_err=True)
                if nic:
                    logger.info('slot: %s, nic %s' % (slot, nic))
                else:
                    logger.error("Nic slot map is wrong.Bmc ip is %s,nic slot map is %s"
                                 % (bmc_info['bmc_ip'], nic_list))
                    raise HCCIException(627205, bmc_info['bmc_ip'], nic_list)
        logger.info("Nic slot map check success")


class PreConfig(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(PreConfig, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.implement = RepPreConfigImpl(project_id, pod_id)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id):
        try:
            self.implement.procedure()
            return Message(200)
        except HCCIException as e1:
            logger.error("pre_config fail, fail detail is %s" % str(e1))
            return Message(500, e1)
        except Exception as e2:
            logger.error("pre_config fail, fail detail is %s" % str(e2))
            return Message(500, HCCIException(627200, str(e2)))

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

