# -*- coding: utf-8 -*-
import traceback

from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
import utils.common.log as logger
from plugins.DistributedStorage.implement.tc_create_new_pool import CreateNewPool
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain


class CreatePoolIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args("master")
        osd_list = list()
        for node in self.fs_args.get('all_openstack_nodes'):
            for osd in self.fs_args.get('osd_list'):
                if node.get('bmc_ip') == osd.get('bmc_ip'):
                    osd_node = dict(list(node.items())+list(osd.items()))
                    osd_list.append(osd_node)
        for node in osd_list:
            node['storage_pool_name_and_slot'] = node.pop('manage_storage_pool_name')
        self.fs_args['osd_nodes_info'] = osd_list
        self.fs_args['disable_deduplication_compression'] = True

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建存储池，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        if not self.fs_args.get('osd_nodes_info'):
            logger.info('There is no osd node to create new pool for current site, return directly')
            return Message(200)
        try:
            CreateNewPool(project_id, pod_id, self.fs_args).procedure()
        except HCCIException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(626003, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
