# -*- coding: utf-8 -*-
import traceback
import utils.common.log as logger
from utils.common.exception import FCDException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from platforms.project.ProjectUtils import get_project_condition_boolean
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.scripts.implement.tc_enable_os_sandbox import EnableOSSandbox


class EnableOSSandboxIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        params = ParamsGain(self.project_id, self.pod_id, self.db)
        if get_project_condition_boolean(self.project_id, 'TenantStorNewPool|TenantStorNewNode'):
            self.fs_args_list = [params.get_business_separate_expand_fusionstorage_args_while_new_pool_or_new_node()]
        elif get_project_condition_boolean(self.project_id, 'TenantStorFB80&ExpansionServiceStorage'):
            self.fs_args_list = [params.get_business_separate_expand_fusionstorage_args()]
        else:
            self.fs_args_list = [params.get_business_separate_args()]
        self.enable_sandbox = EnableOSSandbox(project_id, pod_id, self.fs_args_list)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：开启节点OS安全沙箱，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.enable_sandbox.procedure()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626388, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.enable_sandbox.cleanup()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, FCDException(626388, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id)
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
