# -*- coding: utf-8 -*-
"""
Storage 升级任务
"""
import traceback

import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.common.parameter_gain import ParamsGain
from plugins.DistributedStorage.basic.scripts.impl.tc_upgrade_preparation import PrepareUpgrade


class UpgradePreparation(StepBaseInterface):
    """
    DistributedStorage Prepare for Upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(UpgradePreparation, self).__init__(project_id, pod_id, regionid_list)
        params_gain = ParamsGain(project_id, pod_id, regionid_list)
        self.fs_args = params_gain.get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an prepare for upgrade task
        """
        logger.info('Start prepare for upgrade task.')
        try:
            PrepareUpgrade(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('prepare for upgrade task failed.')
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            logger.error('prepare for upgrade task failed.')
            return Message(500, FCUException(621018, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('retry prepare for upgrade task.')
        return self.execute(project_id, pod_id, regionid_list, suit_id)
