#!/bin/bash
. localrcs

TIMESTAMP=1234
CHECKTYPE=clear_disk_data
CHECKRESULT=pass

DISKS=

for disk in $(awk '/sd*[a-z]$|nvme/{print $NF}' /proc/partitions | sort -r);do
    size=$(awk '/'"$disk"'$/{printf ("%d", $3/1024)}' /proc/partitions)
    mdadm --misc --zero-superblock /dev/$disk
    dd if=/dev/zero of=/dev/$disk bs=1M count=2048
    dd if=/dev/zero of=/dev/$disk bs=1M seek=$((size-10))
    DISKS="${DISKS},$disk"
done

sync

if grep "dm[0-9]" /proc/partitions;then
    reboot
    sleep 3
    echo b >/proc/sysrq-trigger
fi

CHECKRESULT=pass
CHECKOUTPUT="$DISKS"

feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
